<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2023 The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class MediaPack extends \s9e\TextFormatter\Bundle
{
	/**
	* @var s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static $parser;

	/**
	* @var s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS()
	{
		return '(function(){const c=[""],e=[256],f=["","t"],m=["","id"],aa=["","key"],p=["","type"],ba=["","path"],q=["","width"],t={flags:3089},v=["","height"],ca=["","show_id"],y=["","track_id"],da=["","album_id"],ea=[[/(?:)/,c]],fa=["","video_id"],ha=["","short_id"],ia=["","user","id"],ja=["","type","id"],ka=["","id","type"],la=["","name","id"],ma=["","fid","eid"],na=["","episode_id"],oa=["","user","slug"],z=["","playlist_id"],pa=/"id"\\s*:\\s*"(\\w+)"/,qa=["","user","type","id"],ra=["","host","name","id"],sa=["","oid","vid",
"hash"],ta=["","channel","clip_id"],ua=["","athlete","highlight"],va=["","account_id","event_id"],B={d:[],s:!1},C={d:[],s:!0},wa=["","show_id","episode_id","t"],xa=[[/globalnews\\.ca\\/video\\/(\\d+)/,m]],ya=[/hudl\\.com\\/video\\/(\\w+)(?![\\w\\/])/,m],za=[/flickr\\.com\\/photos\\/[^\\/]+\\/(\\d+)/,m],Aa=[[/([-\\w]+)\\.castos\\.com\\/player\\/(\\d+)/,["","host","id"]]],Ba=[[/247sports\\.com\\/PlayerSport\\/[-\\w]*(\\d+)\\/Embed/,["","player_id"]]],Ca=[/hudl\\.com\\/video\\/\\d+\\/(\\d+)\\/([\\da-f]+)/,ua],Da=[[/(?:open|play)\\.spotify\\.com\\/(?:user\\/[-.\\w]+\\/)?((?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,
m]],Ea=[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],F=[function(a,b){let d={},g;for(g in b.b){let l=b.b[g];var n=!1;if(g in a.b){n=l.d;var k=g,h=a.b[g];D.l=k;for(let r=0;r<n.length&&(h=n[r](h,k),!1!==h);++r);delete D.l;n=h}!1!==n?d[g]=n:"undefined"!==typeof l.y?d[g]=l.y:l.s&&E(a)}Fa(a,d)}],Ga={d:[function(a){let b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],s:!1},Ha={y:360,d:Ea,s:!1},Ia={y:640,d:Ea,s:!1},
Ma={d:[function(a){{var b=G.urlConfig,d=D;let g=Ja(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=Ka(b,g))?(d&&(g.attrValue=a,d.add("err",b,g)),a=!1):a=La(g)}return a}],s:!1},I={e,b:{id:B},j:1,d:F,f:10,k:t,g:5E3},Na={e,b:{id:B,user:B},j:1,d:F,f:10,k:t,g:5E3},Oa={e,b:{height:Ha,id:B,width:Ia},j:1,d:F,f:10,k:t,g:5E3},Pa=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$uAMAZON_ASSOCIATE_TAG"/><xsl:param$uAMAZON_ASSOCIATE_TAG_CA"/><xsl:param$uAMAZON_ASSOCIATE_TAG_DE"/><xsl:param$uAMAZON_ASSOCIATE_TAG_ES"/><xsl:param$uAMAZON_ASSOCIATE_TAG_FR"/><xsl:param$uAMAZON_ASSOCIATE_TAG_IN"/><xsl:param$uAMAZON_ASSOCIATE_TAG_IT"/><xsl:param$uAMAZON_ASSOCIATE_TAG_JP"/><xsl:param$uAMAZON_ASSOCIATE_TAG_UK"/><xsl:param$uMEDIAEMBED_THEME"/>$eABCNEWS"><$t$dabcnews"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//abcnews.go.com/video/embed?id={@id}"$h$b/></$t></$t>$i$eACAST"><$n$dacast"$f"$l$r$kno"$qhttps://embed.acast.com/{@show_id}/{@episode_id}?seek={@t}"$hborder:0;height:188px;max-width:900px;width:100%"/>$i$eAMAZON"><$t$damazon"$h$c120px"><$t$h$a200%"><$n$f"$l$r$kno"$hbackground:url(https://www.amazon.com/favicon.ico) center no-repeat;$b><$m$usrc">//ws-<$w><$v$s@tld=\\\'jp\\\'">fe</$v><$v$s@tld and contains(\\\'desfrinituk\\\',@tld)">eu</$v><$p>na</$p></$w>.assoc-amazon.com/widgets/cm?l=as1&amp;f=ifr&amp;o=<$w><$v$s@tld=\\\'ca\\\'">15&amp;t=$g$AMAZON_ASSOCIATE_TAG_CA"/></$v><$v$s@tld=\\\'de\\\'">3&amp;t=$g$AMAZON_ASSOCIATE_TAG_DE"/></$v><$v$s@tld=\\\'es\\\'">30&amp;t=$g$AMAZON_ASSOCIATE_TAG_ES"/></$v><$v$s@tld=\\\'fr\\\'">8&amp;t=$g$AMAZON_ASSOCIATE_TAG_FR"/></$v><$v$s@tld=\\\'in\\\'">31&amp;t=$g$AMAZON_ASSOCIATE_TAG_IN"/></$v><$v$s@tld=\\\'it\\\'">29&amp;t=$g$AMAZON_ASSOCIATE_TAG_IT"/></$v><$v$s@tld=\\\'jp\\\'">9&amp;t=$g$AMAZON_ASSOCIATE_TAG_JP"/></$v><$v$s@tld=\\\'uk\\\'">2&amp;t=$g$AMAZON_ASSOCIATE_TAG_UK"/></$v><$p>1&amp;t=$g$AMAZON_ASSOCIATE_TAG"/></$p></$w>&amp;asins=$g@id"/></$m></$n></$t></$t>$i$eANCHOR"><$n$danchor"$f"$l$r$kno"$q//anchor.fm/x/embed/episodes/x-{@id}"$hborder:0;height:102px;max-width:768px;width:100%"/>$i$eAPPLEPODCASTS"><$n$dapplepodcasts" allow="autoplay *;encrypted-media *"$f"$l$r$kno"><$w><$v$s@episode_id"><$m$usrc">https://embed.podcasts.apple.com/$g@country"/>/podcast/episode/id$g@podcast_id"/>?theme=$g$MEDIAEMBED_THEME"/>&amp;i=$g@episode_id"/></$m><$m$u$x>border:0;height:175px;max-width:900px;width:100%</$m></$v><$p><$m$usrc">https://embed.podcasts.apple.com/$g@country"/>/podcast/episode/id$g@podcast_id"/>?theme=$g$MEDIAEMBED_THEME"/></$m><$m$u$x>border:0;height:450px;max-width:900px;width:100%</$m></$p></$w></$n>$i$eAUDIOBOOM"><$n$daudioboom"$f"$l$r$kno"$q//audioboom.com/posts/{@id}/embed/v3"$hborder:0;height:150px;max-width:700px;width:100%"/>$i$eAUDIOMACK"><$n$daudiomack"$f"$l$r$kno"><$w><$v$s@mode=\\\'album\\\'"><$m$usrc">https://www.audiomack.com/embed/album/<$w><$v$s@id">$g@id"/></$v><$p>$g@artist"/>/$g@title"/></$p></$w></$m><$m$u$x>border:0;height:400px;max-width:900px;width:100%</$m></$v><$p><$m$usrc">https://www.audiomack.com/embed/song/<$w><$v$s@id">$g@id"/></$v><$p>$g@artist"/>/$g@title"/></$p></$w></$m><$m$u$x>border:0;height:252px;max-width:900px;width:100%</$m></$p></$w></$n>$i$eAUDIUS"><$n$daudius"$f"$l$r$kno"><$m$usrc">https://audius.co/embed/<$w><$v$s@track_id">track/$g@track_id"/>?flavor=compact</$v><$v$s@album_id">album/$g@album_id"/>?flavor=card</$v><$p>playlist/$g@playlist_id"/>?flavor=card</$p></$w></$m><$m$u$x>border:0;height:<$w><$v$s@track_id">12</$v><$p>48</$p></$w>0px;max-width:<$w><$v$s@track_id">9</$v><$p>4</$p></$w>00px;width:100%</$m></$n>$i$eBANDCAMP"><$t$dbandcamp"$h$c400px"><$t$h$a100%"><$n$f"$l$r$kno"$h$b><$m$usrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$w><$v$s@album_id">album=$g@album_id"/><$z$s@track_num">/t=$g@track_num"/></$z></$v><$p>track=$g@track_id"/></$p></$w><$z$s$MEDIAEMBED_THEME=\\\'dark\\\'">/bgcol=333333/linkcol=0f91ff</$z></$m></$n></$t></$t>$i$eBBCNEWS"><$t$dbbcnews"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//www.bbc.com/news/av-embeds/<$w><$v$sstarts-with(@playlist,\\\'/news/\\\')"><$w><$v$scontains(@playlist,\\\'-\\\')">$gsubstring-after(substring-after(translate(@playlist,\\\'A\\\',\\\'#\\\'),\\\'news/\\\'),\\\'-\\\')"/></$v><$p>$gsubstring-after(translate(@playlist,\\\'A\\\',\\\'/\\\'),\\\'/news/\\\')"/></$p></$w></$v><$v$scontains(@id,\\\'/\\\')">$gsubstring-after(@id,\\\'/\\\')"/></$v><$p>$g@id"/></$p></$w></$m></$n></$t></$t>$i$eBITCHUTE"><$t$dbitchute"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://www.bitchute.com/embed/{@id}/"$h$b/></$t></$t>$i$eBLEACHERREPORT"><$t$dbleacherreport"$h$c320px"><$t$h$a100%"><$n$f"$l$r$kno"$q//bleacherreport.com/video_embed?id={@id}&amp;library=video-cms"$h$b/></$t></$t>$i$eBRIGHTCOVE"><$t$dbrightcove"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">https://<$w><$v$s@bckey">link.brightcove.com/services/player/bcpid$g@bcpid"/>?bckey=$g@bckey"/>&amp;bctid=$g@bctid"/>&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640</$v><$p>players.brightcove.net/$g@bcpid"/>/default_default/index.html?videoId=$g@bctid"/></$p></$w></$m></$n></$t></$t>$i$eBUNNY"><$t$dbunny"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://$n.mediadelivery.net/embed/{@video_library_id}/{@video_id}?autoplay=false"$h$b/></$t></$t>$i$eCASTOS"><$n$dcastos"$f"$l$r$kno"$qhttps://player.castos.com/player/{@id}"$hborder:0;height:150px;max-width:900px;width:100%"/>$i$eCBSNEWS"><$t$dcbsnews"$h$c640px"><$t><$w><$v$scontains(@id,\\\'-\\\')"><$m$u$x>$a56.25%</$m><$n$f"$l$r$kno"$qhttps://www.cbsnews.com/embed/videos/{@id}/"$h$b/></$v><$v$s@pid"><$m$u$x>$a62.1875%;padding-bottom:calc(56.25% + 38px)</$m><object data="//www.cbsnews.com/common/video/cbsnews_player.swf"$hheight:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param$uallowfullscreen" value="true"/><param$uflashvars" value="pType=embed&amp;si=254&amp;pid={@pid}"/></object></$v><$p><$m$u$x>$a62.5%;padding-bottom:calc(56.25% + 40px)</$m><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf"$hheight:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param$uallowfullscreen" value="true"/><param$uflashvars" value="si=254&amp;contentValue={@id}"/></object></$p></$w></$t></$t>$i$eCLYP"><$n$dclyp"$f"$l$r$kno"$qhttps://clyp.it/{@id}/widget"$hborder:0;height:265px;max-width:900px;width:100%"/>$i$eCNBC"><$t$dcnbc"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid={@id}&amp;size=640_360"$h$b/></$t></$t>$i$eCNN"><$t$dcnn"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//fave.api.cnn.io/v1/fav/?video={@id}&amp;customer=cnn&amp;edition=international&amp;env=prod"$h$b/></$t></$t>$i$eCNNMONEY"><$t$dcnnmoney"$h$c560px"><$t$h$a64.285714%"><$n$f"$l$r$kno"$q//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&amp;width=560&amp;height=360"$h$b/></$t></$t>$i$eCODEPEN"><$n$dcodepen"$f"$l$r$kno"$qhttps://codepen.io/{@user}/embed/{@id}?height=400&amp;default-tab=html,result"$hborder:0;height:400px;width:100%"/>$i$eCOMEDYCENTRAL"><$t$dcomedycentral"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//media.mtvnservices.com/embed/{@id}"$h$b/></$t></$t>$i$eCOUB"><$t$dcoub"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//coub.com/embed/{@id}"$h$b/></$t></$t>$i$eDAILYMOTION"><$t$ddailymotion"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//www.dailymotion.com/embed/video/$g@id"/><$z$s@t">?start=$g@t"/></$z></$m></$n></$t></$t>$i$eDEMOCRACYNOW"><$t$ddemocracynow"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//www.democracynow.org/embed/<$w><$v$scontains(@id,\\\'/headlines\\\')">headlines/$gsubstring-before(@id,\\\'/headlines\\\')"/></$v><$v$sstarts-with(@id,\\\'2\\\')">story/$g@id"/></$v><$v$sstarts-with(@id,\\\'shows/\\\')">show/$gsubstring-after(@id,\\\'/\\\')"/></$v><$p>$g@id"/></$p></$w></$m></$n></$t></$t>$i$eDUMPERT"><$t$ddumpert"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.dumpert.nl/embed/{translate(@id,\\\'/\\\',\\\'_\\\')}"$h$b/></$t></$t>$i$eEIGHTTRACKS"><$t$deighttracks"$h$c400px"><$t$h$a100%"><$n$f"$l$r$kno"$q//8tracks.com/mixes/{@id}/player_v3_universal"$h$b/></$t></$t>$i$eESPN"><$t$despn"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.espn.com/core/video/$n?id={@id}"$h$b/></$t></$t>$i$eFACEBOOK"><$n$dfacebook"$f"$o$x$l$r$y$j$kno"$hborder:0;height:360px;max-width:640px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/facebook.min.html#<$w><$v$s@id">$g@type"/>$g@id"/></$v><$p>pfbid$g@pfbid"/></$p></$w></$m></$n>$i$eFALSTAD"><$n$dfalstad"$f"$l$r$kno"$hborder:0;height:500px;max-height:90vh;width:100%"><$m$usrc">https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c<$w><$v$s@cct">ct=$g@cct"/></$v><$p>tz=$g@ctz"/></$p></$w></$m></$n>$i$eFLICKR"><$t$dflickr"$h$c500px"><$t$h$a100%"><$n$f"$l$r$kno"$qhttps://www.flickr.com/photos/_/{@id}/player/"$h$b/></$t></$t>$i$eFOXNEWS"><$t$dfoxnews"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//video.foxnews.com/v/video-embed.html?video_id={@id}"$h$b/></$t></$t>$i$eFUNNYORDIE"><$t$dfunnyordie"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.funnyordie.com/embed/{@id}"$h$b/></$t></$t>$i$eGAMESPOT"><$t$dgamespot"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.gamespot.com/videos/embed/{@id}/"$h$b/></$t></$t>$i$eGETTY"><$t$dgetty"$h$c{@width}px"><$t><$m$u$x>display:block;overflow:hidden;position:relative;<$z$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</$z></$m><$n$f"$l$r$kno"$q//embed.gettyimages.com/embed/{@id}?et={@et}&amp;tld=com&amp;sig={@sig}&amp;caption=false&amp;ver=1"$h$b/></$t></$t>$i$eGFYCAT"><$t$dgfycat"$h$c{@width}px"><$t><$m$u$x>display:block;overflow:hidden;position:relative;<$z$s@width&gt;0">padding-bottom:$g100*(@height+44)div@width"/>%;padding-bottom:calc($g100*@height div@width"/>% + 44px)</$z></$m><$n$f"$l$r$kno"$q//gfycat.com/ifr/{@id}?hd=1"$h$b/></$t></$t>$i$eGIFS"><$t$dgifs"$h$c{@width}px"><$t><$m$u$x>display:block;overflow:hidden;position:relative;<$z$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</$z></$m><$n$f"$l$r$kno"$q//gifs.com/embed/{@id}"$h$b/></$t></$t>$i$eGIPHY"><$t$dgiphy"$h$c{@width}px"><$t><$m$u$x>display:block;overflow:hidden;position:relative;<$z$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</$z></$m><$n$f"$l$r$kno"$h$b><$m$usrc">//giphy.com/embed/$g@id"/><$z$s@type=\\\'video\\\'">/video</$z></$m></$n></$t></$t>$i$eGIST"><$n$dgist"$f"$o$x$l$r$y$j$k"$qhttps://s9e.github.io/$n/2/gist.min.html#{@id}"$hborder:0;height:180px;width:100%"/>$i$eGLOBALNEWS"><$t$dglobalnews"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//globalnews.ca/video/embed/{@id}/"$h$b/></$t></$t>$i$eGOFUNDME"><$t$dgofundme"$h$c349px"><$t$h$a118.911175%;padding-bottom:calc(59.312321% + 208px)"><$n$f"$l$r$kno"$q//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund={@id}&amp;image=1&amp;coinfo=1"$h$b/></$t></$t>$i$eGOOGLEDRIVE"><$t$dgoogledrive"$h$c640px"><$t$h$a75%"><$n$f"$l$r$kno"$q//drive.google.com/file/d/{@id}/preview"$h$b/></$t></$t>$i$eGOOGLEPLUS"><$n$dgoogleplus"$f"$o$x$l$r$y$j$kno"$hborder:0;height:240px;max-width:450px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/googleplus.min.html#<$w><$v$s@oid">$g@oid"/></$v><$p>+$g@name"/></$p></$w>/posts/$g@pid"/></$m></$n>$i$eGOOGLESHEETS"><$w><$v$s@type=\\\'chart\\\'"><$t$dgooglesheets"$h$c600px"><$t$h$a62%"><$n$f"$l$r$kno"$qhttps://docs.google.com/spreadsheets/d/{@id}/pubchart?oid={@oid}&amp;format=interactive"$h$b/></$t></$t></$v><$p><$n$dgooglesheets"$f"$l$r$kno"$hborder:0;height:500px;resize:vertical;width:100%"><$m$usrc">https://docs.google.com/spreadsheets/d/$g@id"/>/p<$w><$v$sstarts-with(@id,\\\'e/\\\')">ubhtml?widget=true&amp;headers=false</$v><$p>review</$p></$w>#gid=$g@gid"/></$m></$n></$p></$w>$i$eHUDL"><$t$dhudl"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//www.hudl.com/embed/<$w><$v$s@id">video/$g@id"/></$v><$p>athlete/$g@athlete"/>/highlights/$g@highlight"/></$p></$w></$m></$n></$t></$t>$i$eHULU"><$t$dhulu"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://secure.hulu.com/embed/{@id}"$h$b/></$t></$t>$i$eIGN"><$t$dign"$h$c468px"><$t$h$a56.196581%"><$n$f"$l$r$kno"$q//widgets.ign.com/video/embed/content.html?url={@id}"$h$b/></$t></$t>$i$eIMDB"><$t$dimdb"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&amp;width=640"$h$b/></$t></$t>$i$eIMGUR"><$n$dimgur"$f"$o$x$l$r$ylet c=new MessageChannel;c.port1.onmessage=e=&gt;{{let s=this.style,d=e.data.split(\\\' \\\');s.height=d[0]+\\\'px\\\';s.width=d[1]+\\\'px\\\'}};this.contentWindow.postMessage(\\\'s9e:init\\\',\\\'*\\\',[c.port2])"$kno"$hborder:0;height:400px;max-width:100%;width:542px"><$m$usrc">https://s9e.github.io/$n/2/imgur.min.html#<$z$s@type=\\\'album\\\'">a/</$z>$g@id"/></$m></$n>$i$eINDIEGOGO"><$t$dindiegogo"$h$c222px"><$t$h$a200.45045%"><$n$f"$l$r$kno"$q//www.indiegogo.com/project/{@id}/embedded"$h$b/></$t></$t>$i$eINSTAGRAM"><$n$dinstagram"$f"$o$x$l$r$y$j$kno"$hborder:0;height:540px;max-width:540px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/instagram.min.html#$g@id"/><$z$s$MEDIAEMBED_THEME=\\\'dark\\\'">#theme=dark</$z></$m></$n>$i$eINTERNETARCHIVE"><$w><$v$scontains(@id,\\\'playlist=1\\\')"><$n$dinternetarchive"$f"$l$r$kno"$qhttps://archive.org/embed/{@id}&amp;list_height=150"$hborder:0;height:170px;max-width:640px;width:100%"/></$v><$p><$t$dinternetarchive"$h$c{@width}px"><$t><$m$u$x>display:block;overflow:hidden;position:relative;<$z$s@width&gt;0">padding-bottom:$g100*@height div@width"/>%</$z></$m><$n$f"$l$r$kno"$qhttps://archive.org/embed/{@id}"$h$b/></$t></$t></$p></$w>$i$eIZLESENE"><$t$dizlesene"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.izlesene.com/embedplayer/{@id}?autoplay=0"$h$b/></$t></$t>$i$eJSFIDDLE"><$n$djsfiddle"$f"$l$r$kno"$q//jsfiddle.net/{@id}/{@revision}/embedded/{$MEDIAEMBED_THEME}/"$hborder:0;height:400px;width:100%"/>$i$eJWPLATFORM"><$t$djwplatform"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//content.jwplatform.com/players/{@id}.html"$h$b/></$t></$t>$i$eKALTURA"><$t$dkaltura"$h$c640px"><$t$h$a61.875%;padding-bottom:calc(56.25% + 36px)"><$n$f"$l$r$kno"$h$b><$m$usrc">https://cdnapisec.kaltura.com/p/$g@partner_id"/>/sp/<$w><$v$s@sp">$g@sp"/></$v><$p>$g@partner_id"/>00</$p></$w>/embedIframeJs/uiconf_id/$g@uiconf_id"/>/partner_id/$g@partner_id"/>?$nembed=true&amp;entry_id=$g@entry_id"/></$m></$n></$t></$t>$i$eKHL"><$t$dkhl"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//video.khl.ru/$n/feed/start/{@id}?type_id=18&amp;width=560&amp;height=315"$h$b/></$t></$t>$i$eKICKSTARTER"><$t$dkickstarter"><$w><$v$s@video"><$m$u$x>$c640px</$m><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.kickstarter.com/projects/{@id}/widget/video.html"$h$b/></$t></$v><$p><$m$u$x>$c220px</$m><$t$h$a190.909091%"><$n$f"$l$r$kno"$q//www.kickstarter.com/projects/{@id}/widget/card.html"$h$b/></$t></$p></$w></$t>$i$eLIBSYN"><$n$dlibsyn"$f"$l$r$kno"$q//html5-player.libsyn.com/embed/episode/id/{@id}/thumbnail/no"$hborder:0;height:90px;max-width:900px;width:100%"/>$i$eLIVELEAK"><$t$dliveleak"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.liveleak.com/e/{@id}"$h$b/></$t></$t>$i$eLIVESTREAM"><$t$dlivestream"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//<$w><$v$s@clip_id">cdn.livestream.com/embed/$g@channel"/>?layout=4&amp;autoplay=false&amp;clip=$g@clip_id"/></$v><$p>livestream.com/accounts/$g@account_id"/>/events/$g@event_id"/><$z$s@video_id">/videos/$g@video_id"/></$z>/player?autoPlay=false</$p></$w></$m></$n></$t></$t>$i$eMAILRU"><$t$dmailru"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://my.mail.ru/video/embed/{@id}"$h$b/></$t></$t>$i$eMASTODON"><$n$dmastodon"$f"$o$x$l$r$y$j$kno"$hborder:0;height:300px;max-width:550px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/mastodon.min.html#$g@name"/><$z$s@host and@host!=\\\'mastodon.social\\\'">@$g@host"/></$z>/$g@id"/></$m></$n>$i$eMEDIUM"><$n$dmedium"$f"$o$x$l$r$y$j$kno"$qhttps://s9e.github.io/$n/2/medium.min.html#{@id}"$hborder:0;height:316px;max-width:900px;width:100%"/>$i$eMEGAPHONE"><$n$dmegaphone"$f"$l$r$kno"$hborder:0;height:200px;max-width:900px;width:100%"><$m$usrc">https://player.megaphone.fm/$g@id"/><$z$s$MEDIAEMBED_THEME=\\\'light\\\'">?light=true</$z></$m></$n>$i$eMETACAFE"><$t$dmetacafe"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.metacafe.com/embed/{@id}/"$h$b/></$t></$t>$i$eMIXCLOUD"><$n$dmixcloud"$f"$l$r$kno"$hborder:0;height:120px;max-width:900px;width:100%"><$m$usrc">//www.mixcloud.com/widget/$n/?feed=%2F$g@id"/>%2F&amp;light=<$z$s$MEDIAEMBED_THEME!=\\\'dark\\\'">1</$z></$m></$n>$i$eMLB"><$t$dmlb"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://www.mlb.com/video/share/c-{@id}"$h$b/></$t></$t>$i$eMRCTV"><$t$dmrctv"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://www.mrctv.org/embed/{@id}"$h$b/></$t></$t>$i$eMSNBC"><$t$dmsnbc"$h$c640px"><$t><$w><$v$scontains(@id,\\\'_\\\')"><$m$u$x>$a68.75%;padding-bottom:calc(56.25% + 80px)</$m><$n$f"$l$r$kno"$q//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid={@id}"$h$b/></$v><$p><$m$u$x>$a56.25%</$m><$n$f"$l$r$kno"$qhttps://www.msnbc.com/msnbc/embedded-video/{@id}"$h$b/></$p></$w></$t></$t>$i$eNATGEOCHANNEL"><$t$dnatgeochannel"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//channel.nationalgeographic.com/{@id}/embed/"$h$b/></$t></$t>$i$eNATGEOVIDEO"><$t$dnatgeovideo"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}"$h$b/></$t></$t>$i$eNBCNEWS"><$t$dnbcnews"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.nbcnews.com/widget/video-embed/{@id}"$h$b/></$t></$t>$i$eNBCSPORTS"><$t$dnbcsports"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/{@id}?parentUrl="$h$b/></$t></$t>$i$eNHL"><$t$dnhl"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">https://www.nhl.com/video/embed<$z$s@t">/t-$g@t"/></$z><$z$s@c">/c-$g@c"/></$z>?autostart=false</$m></$n></$t></$t>$i$eNPR"><$n$dnpr"$f"$l$r$kno"$q//www.npr.org/player/embed/{@i}/{@m}"$hborder:0;height:228px;max-width:800px;width:100%"/>$i$eNYTIMES"><$t$dnytimes"$h$c585px"><$t$h$a68.376068%"><$n$f"$l$r$kno"$q//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}"$h$b/></$t></$t>$i$eODYSEE"><$t$dodysee"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">https://odysee.com/$/embed/<$w><$v$s@id"><$w><$v$s@name">$g@name"/></$v><$p>-</$p></$w>/$g@id"/></$v><$p>$g@path"/></$p></$w></$m></$n></$t></$t>$i$eORFIUM"><$n$dorfium"$f"$l$r$kno"><$m$usrc">https://www.orfium.com/embedded/<$w><$v$s@album_id">album/$g@album_id"/></$v><$v$s@playlist_id">playlist/$g@playlist_id"/></$v><$v$s@set_id">live-set/$g@set_id"/></$v><$p>track/$g@track_id"/></$p></$w></$m><$m$u$x>border:0;height:<$w><$v$s@album_id">550</$v><$p>275</$p></$w>px;max-width:900px;width:100%</$m></$n>$i$ePASTEBIN"><$n$dpastebin"$f"$l$r$k"$q//pastebin.com/embed_$n.php?i={@id}"$hborder:0;height:300px;resize:vertical;width:100%"/>$i$ePINTEREST"><$n$dpinterest"$f"$o$x$l$r$y$j$kno"$qhttps://s9e.github.io/$n/2/pinterest.min.html#{@id}"><$m$u$x>border:0;height:360px;max-width:<$w><$v$scontains(@id,\\\'/\\\')">730</$v><$p>345</$p></$w>px;width:100%</$m></$n>$i$ePODBEAN"><$n$dpodbean"$f"$l$r$kno"$qhttps://www.podbean.com/player-v2/?i={@id}"$hborder:0;height:150px;max-width:900px;width:100%"/>$i$ePREZI"><$t$dprezi"$h$c550px"><$t$h$a72.727273%"><$n$f"$l$r$kno"$q//prezi.com/embed/{@id}/"$h$b/></$t></$t>$i$eREDDIT"><$n$dreddit"$f"$o$x$l$r$y$j$kno"$qhttps://s9e.github.io/$n/2/reddit.min.html#{@id}{@path}#theme={$MEDIAEMBED_THEME}"$hborder:0;height:165px;max-width:800px;width:100%"/>$i$eRUMBLE"><$t$drumble"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://rumble.com/embed/{@id}/"$h$b/></$t></$t>$i$eRUTUBE"><$t$drutube"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//rutube.ru/play/embed/{@id}"$h$b/></$t></$t>$i$eSCRIBD"><$n$dscribd"$f"$l$r$kno"$qhttps://www.scribd.com/embeds/{@id}/content?view_mode=scroll&amp;show_recommendations=false"$hborder:0;height:500px;resize:vertical;width:100%"/>$i$eSENDVID"><$t$dsendvid"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//sendvid.com/embed/{@id}"$h$b/></$t></$t>$i$eSLIDESHARE"><$t$dslideshare"$h$c597px"><$t$h$a81.407035%"><$n$f"$l$r$kno"$qhttps://www.slideshare.net/slideshow/embed_code/key/{@key}"$h$b/></$t></$t>$i$eSOUNDCLOUD"><$n$dsoundcloud"$f"$l$r$kno"><$m$usrc">https://w.soundcloud.com/player/?url=<$w><$v$s@playlist_id">https%3A//api.soundcloud.com/playlists/$g@playlist_id"/>%3Fsecret_token%3D$g@secret_token"/></$v><$v$s@track_id">https%3A//api.soundcloud.com/tracks/$g@track_id"/>%3Fsecret_token%3D$g@secret_token"/></$v><$p><$z$snot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</$z>$g@id"/></$p></$w></$m><$m$u$x>border:0;height:<$w><$v$s@playlist_id or contains(@id,\\\'/sets/\\\')">450</$v><$p>166</$p></$w>px;max-width:900px;width:100%</$m></$n>$i$eSPORCLE"><$n$dsporcle"$f"$o$x$l$r$y$j$kno"$qhttps://s9e.github.io/$n/2/sporcle.min.html#{@id}"$hborder:0;height:535px;max-width:820px;width:100%"/>$i$eSPORTSNET"><$t$dsportsnet"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId={@id}"$h$b/></$t></$t>$i$eSPOTIFY"><$n$dspotify" allow="encrypted-media"$f"$l$r$kno"$qhttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"><$m$u$x>border:0;border-radius:12px;height:<$w><$v$sstarts-with(@id,\\\'episode\\\')or starts-with(@id,\\\'show\\\')or starts-with(@id,\\\'track\\\')">152</$v><$p>380</$p></$w>px;max-width:900px;width:100%</$m></$n>$i$eSPREAKER"><$n$dspreaker"$f"$l$r$kno"$qhttps://widget.spreaker.com/player?episode_id={@episode_id}&amp;show_id={@show_id}&amp;theme={$MEDIAEMBED_THEME}"$hborder:0;height:{400-200*boolean(@episode_id)}px;max-width:900px;width:100%"/>$i$eSTEAMSTORE"><$n$dsteamstore"$f"$l$r$kno"$q//store.steampowered.com/widget/{@id}"$hborder:0;height:190px;max-width:900px;width:100%"/>$i$eSTITCHER"><$n$dstitcher"$f"$l$r$kno"$qhttps://www.stitcher.com/embed/{@fid}/{@eid}"$hborder:0;height:150px;max-width:900px;width:100%"/>$i$eSTRAWPOLL"><$t$dstrawpoll"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$k"$q//www.strawpoll.me/embed_1/{@id}"$h$b/></$t></$t>$i$eSTREAMABLE"><$t$dstreamable"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//streamable.com/e/{@id}"$h$b/></$t></$t>$i$eSTREAMJA"><$t$dstreamja"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://streamja.com/embed/{@id}"$h$b/></$t></$t>$i$eTEAMCOCO"><$t$dteamcoco"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//teamcoco.com/embed/v/{@id}"$h$b/></$t></$t>$i$eTED"><$t$dted"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//embed.ted.com/$g@id"/><$z$snot(contains(@id,\\\'.html\\\'))">.html</$z></$m></$n></$t></$t>$i$eTELEGRAM"><$n$dtelegram"$f"$o$x$l$r$y$j$kno"$hborder:0;height:96px;max-width:500px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/telegram.min.html#$g@id"/><$z$s$MEDIAEMBED_THEME=\\\'dark\\\'">#theme=dark</$z></$m></$n>$i$eTHEATLANTIC"><$t$dtheatlantic"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.theatlantic.com/video/$n/{@id}/"$h$b/></$t></$t>$i$eTHEGUARDIAN"><$t$dtheguardian"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//embed.theguardian.com/embed/video/{@id}"$h$b/></$t></$t>$i$eTHEONION"><$t$dtheonion"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.theonion.com/video_embed/?id={@id}"$h$b/></$t></$t>$i$eTIKTOK"><$n$dtiktok"$f"$o$x$l$r$y$j$kno"$qhttps://s9e.github.io/$n/2/tiktok.min.html#{@id}"$hborder:0;height:740px;max-width:325px;width:100%"/>$i$eTMZ"><$t$dtmz"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}"$h$b/></$t></$t>$i$eTRADINGVIEW"><$n$dtradingview"$f"$l$r$kno"$hborder:0;height:400px;width:100%"><$m$usrc">https://s.tradingview.com/<$w><$v$s@symbol">widgetembed/?interval=D&amp;symbol=$gtranslate(@symbol,\\\'-\\\',\\\':\\\')"/></$v><$p>embed/$g@chart"/></$p></$w></$m></$n>$i$eTRAILERADDICT"><$t$dtraileraddict"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//v.traileraddict.com/{@id}"$h$b/></$t></$t>$i$eTRENDINGVIEWS"><$t$dtrendingviews"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://mydailyfreedom.com/tv/embed/{@id}"$h$b/></$t></$t>$i$eTUMBLR"><$n$dtumblr"$f"$o$x$l$r$y$j$kno"$qhttps://s9e.github.io/$n/2/tumblr.min.html#{@key}/{@id}"$hborder:0;height:300px;max-width:542px;width:100%"/>$i$eTWENTYFOURSEVENSPORTS"><$w><$v$s@video_id"><$t$dtwentyfoursevensports"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://www.cbssports.com/video/player/embed?args=player_id%3D{@video_id}%26channel%3Dmobilevideo%26pcid%3D{@video_id}%26width%3D640%26height%3D360%26autoplay%3Dfalse%26comp_ads_enabled%3Dfalse%26uvpc%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports.xml%26uvpc_m%3Dhttp%3A%2F%2Fsports.cbsimg.net%2Fvideo%2Fuvp%2Fconfig%2Fv4%2Fuvp_247sports_m.xml%26partner%3D247%26partner_m%3D247_mobile%26utag%3D247sportssite%26resizable%3Dtrue"$h$b/></$t></$t></$v><$p><$n$dtwentyfoursevensports"$f"$l$r$ywindow.addEventListener(\\\'message\\\',function(e){{if(e.source===this.contentWindow&amp;&amp;e.data.height)this.style.height=e.data.height+\\\'px\\\'}})"$kno"$qhttps://247sports.com/PlayerSport/{@player_id}/Embed/"$hborder:0;height:200px;max-width:600px;width:100%"/></$p></$w>$i$eTWITCH"><$t$dtwitch"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$ythis.contentWindow.postMessage(\\\'\\\',\\\'*\\\')"$kno"$qhttps://s9e.github.io/$n/2/twitch.min.html#channel={@channel};clip_id={@clip_id};t={@t};video_id={@video_id}"$h$b/></$t></$t>$i$eTWITTER"><$n$dtwitter" allow="autoplay *"$f"$o$x$l$r$y$j$kno"$hborder:0;height:273px;max-width:550px;width:100%"><$m$usrc">https://s9e.github.io/$n/2/twitter.min.html#$g@id"/><$z$s$MEDIAEMBED_THEME=\\\'dark\\\'">#theme=dark</$z></$m></$n>$i$eUSTREAM"><$t$dustream"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//www.ustream.tv/embed/<$w><$v$s@vid">recorded/$g@vid"/></$v><$p>$g@cid"/></$p></$w>?html5ui</$m></$n></$t></$t>$i$eVBOX7"><$t$dvbox7"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//vbox7.com/emb/external.php?vid={@id}"$h$b/></$t></$t>$i$eVEOH"><$t$dveoh"$h$c640px"><$t$h$a62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v{@id}&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous"$hheight:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param$uallowfullscreen" value="true"/></object></$t></$t>$i$eVEVO"><$t$dvevo"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://embed.vevo.com/?isrc={@id}"$h$b/></$t></$t>$i$eVIDEODETECTIVE"><$t$dvideodetective"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid={@id}"$h$b/></$t></$t>$i$eVIMEO"><$t$dvimeo"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$h$b><$m$usrc">//player.vimeo.com/video/$g@id"/><$z$s@h">?h=$g@h"/></$z><$z$s@t">#t=$g@t"/></$z></$m></$n></$t></$t>$i$eVINE"><$t$dvine"$h$c480px"><$t$h$a100%"><$n$f"$l$r$kno"$qhttps://vine.co/v/{@id}/embed/simple?audio=1"$h$b/></$t></$t>$i$eVK"><$t$dvk"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//vk.com/video_ext.php?oid={@oid}&amp;id={@vid}&amp;hash={@hash}&amp;hd=1"$h$b/></$t></$t>$i$eVOCAROO"><$n$dvocaroo"$f"$l$r$kno"$qhttps://vocaroo.com/embed/{@id}"$hborder:0;height:80px;max-width:900px;width:100%"/>$i$eVOX"><$t$dvox"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//player.ooyala.com/$n.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec={@id}"$h$b/></$t></$t>$i$eWASHINGTONPOST"><$t$dwashingtonpost"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//www.washingtonpost.com/video/c/embed/{@id}"$h$b/></$t></$t>$i$eWAVEKIT"><$n$dwavekit"$f"$l$r$kno"><$m$usrc">https://play.wavekit.app/embed/<$w><$v$s@playlist_id">playlist/$g@playlist_id"/></$v><$p>audio/$g@audio_id"/></$p></$w></$m><$m$u$x>border:0;height:<$w><$v$s@playlist_id">40</$v><$p>17</$p></$w>0px;max-width:900px;width:100%</$m></$n>$i$eWISTIA"><$w><$v$s@type=\\\'audio\\\'"><$n$dwistia"$f"$l$r$kno"$qhttps://fast.wistia.net/embed/$n/{@id}"$hborder:0;height:218px;max-width:900px;width:100%"/></$v><$p><$t$dwistia"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://fast.wistia.net/embed/$n/{@id}"$h$b/></$t></$t></$p></$w>$i$eWSHH"><$t$dwshh"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//worldstarhiphop.com/embed/{@id}"$h$b/></$t></$t>$i$eWSJ"><$t$dwsj"$h$c512px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//video-api.wsj.com/api-video/player/$n.html?guid={@id}"$h$b/></$t></$t>$i$eXBOXCLIPS"><$t$dxboxclips"$h$c560px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//gameclips.io/{@user}/{@id}/embed"$h$b/></$t></$t>$i$eXBOXDVR"><$t$dxboxdvr"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//gamerdvr.com/gamer/{@user}/video/{@id}/embed"$h$b/></$t></$t>$i$eYOUKU"><$t$dyouku"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$q//player.youku.com/embed/{@id}"$h$b/></$t></$t>$i$eYOUMAKER"><$t$dyoumaker"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$qhttps://www.youmaker.com/embed/{@id}"$h$b/></$t></$t>$i$eYOUTUBE"><$t$dyoutube"$h$c640px"><$t$h$a56.25%"><$n$f"$l$r$kno"$hbackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$b><$m$usrc">https://www.youtube.com/embed/$g@id"/><$z$s@list">?list=$g@list"/></$z><$z$s@t"><$w><$v$s@list">&amp;</$v><$p>?</$p></$w>start=$g@t"/></$z></$m></$n></$t></$t>$i$ebr"><br/>$i$ee|i|s"/>$ep"><p><xsl:apply-templates/></p>$i</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:"display:block;overflow:hidden;position:relative;padding-bottom:",$b:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$c:"display:inline-block;width:100%;max-width:",$d:\' data-s9e-mediaembed="\',$e:\'<xsl:template match="\',$f:\' allowfullscreen="\',$g:\'<xsl:value-of select="\',$h:\' style="\',$i:"</xsl:template>",$j:"let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])\\"",$k:\' scrolling="\',
$l:\' loading="\',$m:"xsl:attribute",$n:"iframe",$o:\' data-s9e-livepreview-ignore-attrs="\',$p:"xsl:otherwise",$q:\' src="\',$r:\'lazy"\',$s:\' test="\',$t:"span",$u:\' name="\',$v:"xsl:when",$w:"xsl:choose",$x:\'style"\',$y:\' onload="\',$z:"xsl:if"}[a]});
function Ja(a){let b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),d={};"scheme user pass host port path query fragment".split(" ").forEach(function(g,n){d[g]=""<b[n+1]?b[n+1]:""});d.scheme=d.scheme.toLowerCase();d.host=d.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(d.host)&&"undefined"!==typeof punycode&&(d.host=punycode.toASCII(d.host));return d}
function La(a){let b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=Qa(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+Qa(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");let d=a.path+a.query+a.fragment;d=d.replace(/%.?[a-f]/g,function(g){return g.toUpperCase()},d);b+=Ra(d);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));return b}
function Ra(a){return a.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,function(b){return"%"+b[0].charCodeAt(0).toString(16).toUpperCase()})}
function Ka(a,b){if(""!==b.scheme&&!a.F.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var d;if(d=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(d=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(d))for(var g=4,n=d.split(".");0<=--g;){if("0"===n[g][0]||255<n[g]){d=!1;break a}}else d=!1;if(d=!d)d=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),d=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(d)&&d)}if(d)return"URL host is invalid";if(a.G&&
a.G.test(b.host)||a.J&&!a.J.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function Sa(a){return a.replace(/[<>&"]/g,b=>({"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"})[b])}function Ta(a){return a.replace(/[<>&]/g,b=>({"<":"&lt;",">":"&gt;","&":"&amp;"})[b])}function Qa(a){return encodeURIComponent(a).replace(/[!\'()*]/g,b=>"%"+b.charCodeAt(0).toString(16).toUpperCase())}function Ua(){this.p={};this.u=[]}
Ua.prototype.add=function(a,b,d){d=d||{};"attrName"in d||!this.l||(d.attrName=this.l);"tag"in d||!this.o||(d.tag=this.o);this.p[a]&&this.p[a].forEach(g=>{g(b,d)});this.u.push([a,b,d])};Ua.prototype.getLogs=function(){return this.u};Ua.prototype.on=function(a,b){this.p[a].push(b)};function Va(a,b){D.add("debug",a,b)}function K(a,b,d,g,n){this.q=+a;this.name=b;this.l=+d;this.o=+g;this.x=+n||0;this.b={};this.z=[];isNaN(a+d+g)&&E(this)}K.prototype.p=!1;
function E(a){a.p||(a.p=!0,a.z.forEach(function(b){E(b)}))}function Wa(a,b){Xa(a,b)?(a.v=b,b.u=a,a.z.push(b),a.p&&E(b)):Xa(b,a)&&(a.u=b,b.v=a)}function Xa(a,b){return a.name===b.name&&1===a.q&&2===b.q&&a.l<=a.l}function Ya(a){let b={};for(let d in a.b)b[d]=a.b[d];return b}function Za(a,b){return a.p||!Xa(b,a)||a.u&&a.u!==b||b.v&&b.v!==a?!1:!0}function Fa(a,b){a.b={};for(let d in b)a.b[d]=b[d]}let L,$a,M,N,O,ab,D=new Ua,P,Q;
const S={MediaEmbed:{I:function(a,b){b.forEach(d=>{let g=d[0][0];R(3,"MEDIA",d[0][1],g.length,-10).b.url=g})},B:"://",C:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,D:5E4}};let T;
const G={"MediaEmbed.hosts":{"247sports.com":"twentyfoursevensports","8tracks.com":"eighttracks","abcnews.go.com":"abcnews","acast.com":"acast","amazon.ca":"amazon","amazon.co.jp":"amazon","amazon.co.uk":"amazon","amazon.com":"amazon","amazon.de":"amazon","amazon.es":"amazon","amazon.fr":"amazon","amazon.in":"amazon","amazon.it":"amazon","anchor.fm":"anchor","archive.org":"internetarchive","audioboo.fm":"audioboom","audioboom.com":"audioboom","audiomack.com":"audiomack","audius.co":"audius","bandcamp.com":"bandcamp",
"bbc.co.uk":"bbcnews","bbc.com":"bbcnews","bitchute.com":"bitchute","bleacherreport.com":"bleacherreport","castos.com":"castos","cbsnews.com":"cbsnews","cc.com":"comedycentral","channel.nationalgeographic.com":"natgeochannel","clyp.it":"clyp","cnbc.com":"cnbc","cnn.com":"cnn","codepen.io":"codepen","comedycentral.com":"comedycentral","coub.com":"coub","dai.ly":"dailymotion","dailymotion.com":"dailymotion","democracynow.org":"democracynow","docs.google.com":"googlesheets","drive.google.com":"googledrive",
"dumpert.nl":"dumpert","espn.com":"espn","espn.go.com":"espn","facebook.com":"facebook","falstad.com":"falstad","fb.watch":"facebook","flic.kr":"flickr","flickr.com":"flickr","funnyordie.com":"funnyordie","gameclips.io":"xboxclips","gamerdvr.com":"xboxdvr","gamespot.com":"gamespot","gettyimages.be":"getty","gettyimages.cn":"getty","gettyimages.co.jp":"getty","gettyimages.co.uk":"getty","gettyimages.com":"getty","gettyimages.com.au":"getty","gettyimages.de":"getty","gettyimages.dk":"getty","gettyimages.es":"getty",
"gettyimages.fr":"getty","gettyimages.ie":"getty","gettyimages.it":"getty","gettyimages.nl":"getty","gettyimages.pt":"getty","gettyimages.se":"getty","gfycat.com":"gfycat","gifs.com":"gifs","giphy.com":"giphy","github.com":"gist","globalnews.ca":"globalnews","gofundme.com":"gofundme","gty.im":"getty","hudl.com":"hudl","hulu.com":"hulu","iframe.mediadelivery.net":"bunny","ign.com":"ign","imdb.com":"imdb","imgur.com":"imgur","indiegogo.com":"indiegogo","instagram.com":"instagram","izlesene.com":"izlesene",
"jsfiddle.net":"jsfiddle","jwplatform.com":"jwplatform","kaltura.com":"kaltura","kickstarter.com":"kickstarter","libsyn.com":"libsyn","link.brightcove.com":"brightcove","link.tospotify.com":"spotify","liveleak.com":"liveleak","livestre.am":"livestream","livestream.com":"livestream","mastodon.social":"mastodon","medium.com":"medium","megaphone.fm":"megaphone","megaphone.link":"megaphone","metacafe.com":"metacafe","mixcloud.com":"mixcloud","mlb.com":"mlb","money.cnn.com":"cnnmoney","mrctv.org":"mrctv",
"msnbc.com":"msnbc","my.mail.ru":"mailru","mydailyfreedom.com":"trendingviews","n.pr":"npr","nbcnews.com":"nbcnews","nbcsports.com":"nbcsports","nhl.com":"nhl","npr.org":"npr","nytimes.com":"nytimes","odysee.com":"odysee","open.spotify.com":"spotify","orfium.com":"orfium","pastebin.com":"pastebin","pinterest.com":"pinterest","play.spotify.com":"spotify","play.wavekit.app":"wavekit","players.brightcove.net":"brightcove","plus.google.com":"googleplus","podbean.com":"podbean","podcasts.apple.com":"applepodcasts",
"prezi.com":"prezi","reddit.com":"reddit","rumble.com":"rumble","rutube.ru":"rutube","scribd.com":"scribd","sendvid.com":"sendvid","slideshare.net":"slideshare","soundcloud.com":"soundcloud","sporcle.com":"sporcle","sportsnet.ca":"sportsnet","spreaker.com":"spreaker","stitcher.com":"stitcher","store.steampowered.com":"steamstore","strawpoll.me":"strawpoll","streamable.com":"streamable","streamja.com":"streamja","t.me":"telegram","teamcoco.com":"teamcoco","ted.com":"ted","theatlantic.com":"theatlantic",
"theguardian.com":"theguardian","theonion.com":"theonion","tiktok.com":"tiktok","tmz.com":"tmz","tradingview.com":"tradingview","traileraddict.com":"traileraddict","trendingviews.co":"trendingviews","tumblr.com":"tumblr","twitch.tv":"twitch","twitter.com":"twitter","ustream.tv":"ustream","vbox7.com":"vbox7","veoh.com":"veoh","vevo.com":"vevo","video.bunnycdn.com":"bunny","video.foxnews.com":"foxnews","video.khl.ru":"khl","video.nationalgeographic.com":"natgeovideo","videodetective.com":"videodetective",
"vimeo.com":"vimeo","vine.co":"vine","vk.com":"vk","vkontakte.ru":"vk","voca.ro":"vocaroo","vocaroo.com":"vocaroo","vox.com":"vox","washingtonpost.com":"washingtonpost","wistia.com":"wistia","worldstar.com":"wshh","worldstarhiphop.com":"wshh","wsj.com":"wsj","xboxclips.com":"xboxclips","xboxdvr.com":"xboxdvr","youku.com":"youku","youmaker.com":"youmaker","youtu.be":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{abcnews:[[[/abcnews\\.go\\.com\\/(?:video\\/embed\\?id=|[^\\/]+\\/video\\/[^\\/]+-)(\\d+)/,
m]],[]],acast:[[[/play\\.acast\\.com\\/s\\/([-.\\w]+)\\/([-.\\w]+)(?:\\?seek=(\\d+))?/,wa],[/shows\\.acast\\.com\\/([-.\\w]+)\\/(?:episodes\\/)?([-.\\w]+)(?:\\?seek=(\\d+))?/,wa]],[{a:[[/"showId":"([-0-9a-f]+)/,ca],[/"id":"([-0-9a-f]+)/,na]],match:[[/play\\.acast\\.com\\/s\\/[-.\\w]+\\/./,c],[/shows\\.acast\\.com\\/[-.\\w]+\\/./,c]],n:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}"}]],amazon:[[[/\\/(?:dp|gp\\/product)\\/([A-Z0-9]+)/,m],[/amazon\\.(?:co\\.)?(ca|de|es|fr|in|it|jp|uk)/,["","tld"]]],[]],anchor:[[[/anchor.fm\\/(?:[-\\w]+\\/)*episodes\\/(?:[-\\w]+-)(\\w+)(?![-\\w])/,
m]],[]],applepodcasts:[[[/podcasts\\.apple\\.com\\/(\\w+)\\/podcast\\/[-\\w]*\\/id(\\d+)(?:\\?i=(\\d+))?/,["","country","podcast_id","episode_id"]]],[]],audioboom:[[[/audioboo(?:\\.f|m\\.co)m\\/(?:boo|post)s\\/(\\d+)/,m]],[]],audiomack:[[[/audiomack\\.com\\/(album|song)\\/([-\\w]+)\\/([-\\w]+)/,["","mode","artist","title"]],[/audiomack\\.com\\/([-\\w]+)\\/(album|song)\\/([-\\w]+)/,["","artist","mode","title"]]],[]],audius:[[],[{a:[[pa,y]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/(?!album\\/|playlist\\/)([%\\-.\\w]+)/,oa]],n:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}"},
{a:[[pa,da]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/album\\/([%\\-.\\w]+)/,oa]],n:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}"},{a:[[pa,z]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/playlist\\/([%\\-.\\w]+)/,oa]],n:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}"}]],bandcamp:[[],[{a:[[/\\/album=(\\d+)/,da]],match:[[/bandcamp\\.com\\/album\\/./,c]]},{a:[[/"album_id":(\\d+)/,da],[/"track_num":(\\d+)/,
["","track_num"]],[/\\/track=(\\d+)/,y]],match:[[/bandcamp\\.com\\/track\\/./,c]]}]],bbcnews:[[[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/(?:\\w+-)+(\\d+)/,m],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/embed\\/(\\w+\\/\\d+)/,m],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/\\w+\\/(\\d+)/,m],[/bbc\\.co(?:m|\\.uk)\\/news\\/av-embeds\\/(\\d+)/,m]],[]],bitchute:[[[/bitchute\\.com\\/(?:embed|video)\\/([-\\w]+)/,m]],[]],bleacherreport:[[],[{a:[[/id="video-([-\\w]+)/,m],[/video_embed\\?id=([-\\w]+)/,m]],match:[[/\\/articles\\/./,
c]]}]],brightcove:[[[/link\\.brightcove\\.com\\/services\\/player\\/bcpid(\\d+).*?bckey=([-,~\\w]+).*?bctid=(\\d+)/,["","bcpid","bckey","bctid"]],[/players\\.brightcove\\.net\\/(\\d+)\\/.*?videoId=(\\d+)/,["","bcpid","bctid"]]],[]],bunny:[[[/\\/(?:embed|play)\\/(\\d+)\\/([-\\w]+)/,["","video_library_id","video_id"]]],[]],castos:[Aa,[{a:Aa,match:[[/castos\\.com\\/(?:podcasts\\/[^\\/]*\\/)?episodes\\/./,c]]}]],cbsnews:[[[/cbsnews\\.com\\/videos?\\/(?!watch\\/)([-\\w]+)/,m],[/cbsnews\\.com\\/video\\/watch\\/\\?id=(\\d+)/,m]],[]],clyp:[[[/clyp\\.it\\/(?!user\\/)(\\w+)/,
m]],[]],cnbc:[[[/cnbc\\.com\\/gallery\\/\\?video=(\\d+)/,m]],[{a:[[/byGuid=(\\d+)/,m]],match:[[/cnbc\\.com\\/video\\/20\\d\\d\\/\\d\\d\\/\\d\\d\\/\\w/,c]]}]],cnn:[[[/cnn.com\\/videos\\/(.*\\.cnn)/,m],[/cnn\\.com\\/video\\/data\\/2\\.0\\/video\\/(.*\\.cnn)/,m]],[]],cnnmoney:[[[/money\\.cnn\\.com\\/video\\/(.*\\.cnnmoney)/,m]],[]],codepen:[[[/codepen\\.io\\/([-\\w]+)\\/(?:details|embed|full|live|pen)\\/(\\w+)/,ia]],[]],comedycentral:[[],[{a:[[/(mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)/,m]],match:[[/c(?:c|omedycentral)\\.com\\/(?:full-episode|video-clip)s\\//,
c]]}]],coub:[[[/coub\\.com\\/view\\/(\\w+)/,m]],[]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,m],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,m],[/start=(\\d+)/,f]],[]],democracynow:[[[/democracynow.org\\/(?:embed\\/)?((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)/,m]],[{a:[[/democracynow\\.org\\/((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)\' rel=\'canonical/,m]],match:[[/m\\.democracynow\\.org\\/stories\\/\\d/,c]]}]],dumpert:[[[/dumpert\\.nl\\/(?:item|mediabase)\\/(\\d+[\\/_]\\w+)/,m]],[]],
eighttracks:[[[/8tracks\\.com\\/[-\\w]+\\/(\\d+)(?=#|$)/,m]],[{a:[[/eighttracks:\\/\\/mix\\/(\\d+)/,m]],match:[[/8tracks\\.com\\/[-\\w]+\\/\\D/,c]]}]],espn:[[[/video\\/(?:clip(?:\\?id=|\\/_\\/id\\/))?(\\d+)/,m]],[]],facebook:[[[/\\/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com\\/(?:[\\/\\w]+\\/permalink|(?!marketplace\\/|pages\\/|groups\\/).*?)(?:\\/|fbid=|\\?v=)(\\d+)(?=$|[\\/?&#])/,m],[/facebook\\.com\\/([.\\w]+)\\/(?=(?:post|video)s?\\/)([pv])/,["","user","type"]],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,p],[/facebook\\.com\\/watch\\/\\?([pv])=/,
p],[/facebook.com\\/groups\\/[^\\/]*\\/(p)osts\\/(\\d+)/,ja],[/facebook\\.com\\/([.\\w]+)\\/posts\\/pfbid(\\w+)/,["","user","pfbid"]],[/facebook\\.com\\/permalink\\.php\\?story_fbid=(?:(\\d+)|pfbid(\\w+))&id=(\\d+)/,["","id","pfbid","page_id"]]],[{a:[[/facebook\\.com\\/([.\\w]+)\\/([pv])\\w+\\/(\\d+)(?!\\w)/,qa]],r:"User-agent: PHP (not Mozilla)",match:[[/facebook\\.com\\/[.\\w]+\\/posts\\/pfbid/,c]],n:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2F{@user}%2Fposts%2Fpfbid{@pfbid}"},{a:[[/story_fbid=(\\d+)/,
m]],r:"User-agent: PHP (not Mozilla)",match:[[/facebook\\.com\\/permalink\\.php\\?story_fbid=pfbid(\\w+)&id=(\\d+)/,["","pfbid","page_id"]]],n:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2Fpermalink.php%3Fstory_fbid%3Dpfbid{@pfbid}%26id%3D{@page_id}"},{a:[[/facebook\\.com\\/watch\\/\\?(v)=(\\d+)/,ja],[/facebook\\.com\\/([.\\w]+)\\/(v)ideos\\/(\\d+)/,qa]],r:"User-agent: PHP (not Mozilla)",match:[[/fb\\.watch\\/./,c]]}]],falstad:[[[/falstad\\.com\\/circuit\\/circuitjs\\.html\\?c(?:ct=([^&]+)|tz=([-+=\\w]+))/,
["","cct","ctz"]]],[]],flickr:[[za,[/flic\\.kr\\/(?!p\\/)[^\\/]+\\/(\\d+)/,m]],[{a:[za],match:[[/flic\\.kr\\/p\\/(\\w+)/,["","short"]]],n:"https://www.flickr.com/photo.gne?rb=1&short={@short}"}]],foxnews:[[[/video\\.foxnews\\.com\\/v\\/(\\d+)/,m]],[]],funnyordie:[[[/funnyordie\\.com\\/videos\\/([0-9a-f]+)/,m]],[]],gamespot:[[[/gamespot\\.com.*?\\/(?:events|videos)\\/.*?-(\\d+)\\/(?:[#?].*)?$/,m]],[]],getty:[[],[{a:[[/\\/embed\\/(\\d+)/,m],[/"height":[ "]*(\\d+)/,v],[/"width":[ "]*(\\d+)/,q],[/\\?et=([-=\\w]+)/,["","et"]],[/\\\\u0026sig=([-=\\w]+)/,
["","sig"]]],match:[[/(?:gty\\.im|gettyimages\\.[.\\w]+\\/detail(?=\\/).*?)\\/(\\d+)/,m]],n:"https://embed.gettyimages.com/preview/{@id}"}]],gfycat:[[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?(\\w+)/,m]],[{a:[[/\\/ifr\\/(\\w+)/,m]],match:[[/gfycat\\.com\\/(?!gaming|reactions|stickers|gifs\\/tag)(?:gifs\\/detail\\/|ifr(?:ame)?\\/)?[a-z]/,c]],n:"https://gfycat.com/ifr/{@id}"},{a:[[/"height":(\\d+)/,v],[/"width":(\\d+)/,q]],match:ea,n:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}"}]],
gifs:[[[/gifs\\.com\\/(?:gif\\/)?(\\w+)/,m]],[{a:[[/meta property="og:image:width" content="(\\d+)/,q],[/meta property="og:image:height" content="(\\d+)/,v]],match:ea,n:"https://gifs.com/gif/{@id}"}]],giphy:[[[/giphy\\.com\\/(gif|video|webp)\\w+\\/(?:[-\\w]+-)*(\\w+)/,ja],[/giphy\\.com\\/media\\/(\\w+)\\/\\w+\\.(gif|webp)/,ka],[/i\\.giphy\\.com\\/(\\w+)\\.(gif|webp)/,ka]],[{a:[[/"height"\\s*:\\s*(\\d+)/,v],[/"width"\\s*:\\s*(\\d+)/,q]],match:ea,n:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif"}]],
gist:[[[/gist\\.github\\.com\\/((?:[-\\w]+\\/)?[\\da-f]+(?:\\/[\\da-f]+)?\\b(?!\\/archive))/,m]],[]],globalnews:[xa,[{a:xa,match:[[/globalnews\\.ca\\/video\\/rd\\//,c]]}]],gofundme:[[[/gofundme\\.com\\/(\\w+)(?![^#?])/,m]],[]],googledrive:[[[/drive\\.google\\.com\\/.*?(?:file\\/d\\/|id=)([-\\w]+)/,m]],[]],googleplus:[[[/\\/\\/plus\\.google\\.com\\/(?:u\\/\\d+\\/)?(?:\\+([^\\/]+)|(\\d+))\\/posts\\/(\\w+)/,["","name","oid","pid"]]],[]],googlesheets:[[[/docs\\.google\\.com\\/spreadsheet(?:\\/ccc\\?key=|(?:[^e]\\/)+)((?:e\\/)?[-\\w]+)/,m],[/oid=(\\d+)/,
["","oid"]],[/#gid=(\\d+)/,["","gid"]],[/\\/pub(chart)/,p]],[]],hudl:[[[/hudl\\.com\\/athlete\\/(\\d+)\\/highlights\\/([\\da-f]+)/,ua],Ca,ya],[{a:[Ca,ya],match:[[/hudl\\.com\\/v\\//,c]]}]],hulu:[[],[{a:[[/eid=([-\\w]+)/,m]],match:[[/hulu\\.com\\/watch\\//,c]]}]],ign:[[[/(https?:\\/\\/.*?ign\\.com\\/videos\\/.+)/i,m]],[]],imdb:[[],[{a:[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)\\/[\\/\\w]*embed/,m]],match:[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)/,m]],n:"https://www.imdb.com/video/imdb/vi{@id}/imdb/embed"}]],imgur:[[[/imgur\\.com\\/(a\\/\\w+)/,m],[/i\\.imgur\\.com\\/(\\w{5,7})[lms]?\\./,
m],[/imgur\\.com\\/(\\w+)(?![\\w.\\/])/,m]],[{a:[[/data-id="([\\w\\/]+)"/,m]],match:[[/imgur\\.com\\/(?![art]\\/|user\\/)((?:gallery\\/)?\\w+)(?![\\w.])/,ba]],n:"https://api.imgur.com/oembed.xml?url=/{@path}"}]],indiegogo:[[[/indiegogo\\.com\\/projects\\/([-\\w]+)/,m]],[]],instagram:[[[/instagram\\.com\\/(?:p|reel|tv)\\/([-\\w]+)/,m]],[]],internetarchive:[[],[{a:[[/meta property="twitter:player" content="https:\\/\\/archive.org\\/embed\\/([^\\/"]+)/,m],[/meta property="og:video:width" content="(\\d+)/,q],[/meta property="og:video:height" content="(\\d+)/,
v]],match:[[/archive\\.org\\/(?:details|embed)\\//,c]]}]],izlesene:[[[/izlesene\\.com\\/video\\/[-\\w]+\\/(\\d+)/,m]],[]],jsfiddle:[[[/jsfiddle.net\\/(?:(\\w+)\\/)?(?!\\d+\\b|embedded\\b|show\\b)(\\w+)\\b(?:\\/(\\d+)\\b)?/,["","user","id","revision"]]],[]],jwplatform:[[[/jwplatform\\.com\\/\\w+\\/([-\\w]+)/,m]],[]],kaltura:[[[/\\/p(?:artner_id)?\\/(\\d+)\\//,["","partner_id"]],[/\\/sp\\/(\\d+)\\//,["","sp"]],[/\\/uiconf_id\\/(\\d+)\\//,["","uiconf_id"]],[/\\bentry_id[=\\/](\\w+)/,["","entry_id"]]],[{a:[[/kaltura\\.com\\/+p\\/(\\d+)\\/sp\\/(\\d+)\\/\\w*\\/uiconf_id\\/(\\d+)\\/.*?\\bentry_id=(\\w+)/,
["","partner_id","sp","uiconf_id","entry_id"]]],match:[[/kaltura\\.com\\/(?:media\\/t|tiny)\\/./,c]]}]],khl:[[],[{a:[[/\\/feed\\/start\\/([\\/\\w]+)/,m]],match:[[/video\\.khl\\.ru\\/(?:event|quote)s\\/\\d/,c]]}]],kickstarter:[[[/kickstarter\\.com\\/projects\\/([^\\/]+\\/[^\\/?]+)(?:\\/widget\\/(?:(card)|(video)))?/,["","id","card","video"]]],[]],libsyn:[[],[{a:[[/embed\\/episode\\/id\\/(\\d+)/,m]],match:[[/(?!\\.mp3)....$/,c]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,m]],[{a:[[/liveleak\\.com\\/e\\/(\\w+)/,m]],match:[[/liveleak\\.com\\/view\\?t=/,
c]]}]],livestream:[[[/livestream\\.com\\/accounts\\/(\\d+)\\/events\\/(\\d+)/,va],[/\\/videos\\/(\\d+)/,fa],[/original\\.livestream\\.com\\/(\\w+)\\/video\\?clipId=([-\\w]+)/,ta]],[{a:[[/accounts\\/(\\d+)\\/events\\/(\\d+)/,va]],match:[[/livestream\\.com\\/(?!accounts\\/\\d+\\/events\\/\\d)/,c]]},{a:[[/\\/\\/original\\.livestream\\.com\\/(\\w+)\\/video\\/([-\\w]+)/,ta]],match:[[/livestre.am/,c]]}]],mailru:[[],[{a:[[/"itemId": ?"?(\\d+)/,m]],match:[[/my\\.mail\\.ru\\/\\w+\\/\\w+\\/video\\/\\w+\\/\\d/,c]]}]],mastodon:[[[/\\/\\/([-.\\w]+)\\/@(\\w+)\\/(\\d+)/,
ra]],[{a:[[/"url":"https:\\/\\/([-.\\w]+)\\/@(\\w+)\\/(\\d+)"/,ra]],match:[[/^(https:\\/\\/[^\\/]+)\\/@\\w+@[-.\\w]+\\/(\\d+)/,["","origin","id"]]],n:"{@origin}/api/v1/statuses/{@id}"}]],medium:[[[/medium\\.com\\/(?:s\\/\\w+\\/|@?[-\\w]+\\/)?(?:\\w+-)*([0-9a-f]+)(?!\\w)/,m]],[]],megaphone:[[[/megaphone\\.fm\\/.*?\\?(?:e|selected)=(\\w+)/,m],[/(?:dcs|player|traffic)\\.megaphone\\.fm\\/(\\w+)/,m],[/megaphone\\.link\\/(\\w+)/,m]],[]],metacafe:[[[/metacafe\\.com\\/watch\\/(\\d+)/,m]],[]],mixcloud:[[[/mixcloud\\.com\\/(?!categories|tag)([-\\w]+\\/[^\\/&]+)\\//,
m]],[]],mlb:[[[/mlb\\.com\\/video\\/(?:[-\\w\\/]+\\/)?(?:c-|v|[-\\w]+-c)(\\d+)/,m]],[]],mrctv:[[],[{a:[[/mrctv\\.org\\/embed\\/(\\d+)/,m]],match:[[/mrctv\\.org\\/videos\\/./,c]]}]],msnbc:[[],[{a:[[/embedded-video\\/(?!undefined)(\\w+)/,m]],match:[[/msnbc\\.com\\/[-\\w]+\\/watch\\//,c],[/on\\.msnbc\\.com\\/./,c]]}]],natgeochannel:[[[/channel\\.nationalgeographic\\.com\\/([-\\/\\w]+\\/videos\\/[-\\w]+)/,m]],[]],natgeovideo:[[],[{a:[[/guid="([-\\w]+)"/,m]],match:[[/video\\.nationalgeographic\\.com\\/(?:tv|video)\\/\\w/,c]]}]],nbcnews:[[[/nbcnews\\.com\\/(?:widget\\/video-embed\\/|video\\/[-\\w]+-)(\\d+)/,
m]],[]],nbcsports:[[],[{a:[[/select\\/media\\/(\\w+)/,m]],match:[[/nbcsports\\.com\\/video\\/./,c]]}]],nhl:[[[/nhl\\.com\\/(?:\\w+\\/)?video(?:\\/(?![ct]-)[-\\w]+)?(?:\\/t-(\\d+))?(?:\\/c-(\\d+))?/,["","t","c"]]],[]],npr:[[],[{a:[[/player\\/embed\\/(\\d+)\\/(\\d+)/,["","i","m"]]],r:"Cookie: trackingChoice=false; choiceVersion=1",match:[[/npr\\.org\\/[\\/\\w]+\\/\\d+/,c],[/n\\.pr\\/\\w/,c]]}]],nytimes:[[[/nytimes\\.com\\/video\\/[a-z]+\\/(?:[a-z]+\\/)?(\\d+)/,m],[/nytimes\\.com\\/video\\/\\d+\\/\\d+\\/\\d+\\/[a-z]+\\/(\\d+)/,m]],[{a:[[/\\/video\\/movies\\/(\\d+)/,
m]],match:[[/nytimes\\.com\\/movie(?:s\\/movie)?\\/(\\d+)\\/[-\\w]+\\/trailers/,["","playlist"]]],n:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true"}]],odysee:[[[/odysee\\.com\\/(?:\\$\\/\\w+\\/)?([^:\\/]+)[:\\/](\\w{40})/,la],[/odysee\\.com\\/(@[^:\\/]+:\\w\\/[^:\\/]+:\\w)/,ba]],[{a:[[/"contentUrl".*api\\/\\w+\\/streams\\/\\w+\\/([^\\/]+)\\/(\\w{40})/,la]],match:[[/odysee\\.com\\/@[^\\/:]+:\\w+\\/./,c]]}]],orfium:[[[/album\\/(\\d+)/,da],[/playlist\\/(\\d+)/,z],[/live-set\\/(\\d+)/,["","set_id"]],[/track\\/(\\d+)/,
y]],[]],pastebin:[[[/pastebin\\.com\\/(?!u\\/)(?:\\w+(?:\\.php\\?i=|\\/))?(\\w+)/,m]],[]],pinterest:[[[/pinterest.com\\/pin\\/(\\d+)/,m],[/pinterest.com\\/(?!_\\/|discover\\/|explore\\/|news_hub\\/|pin\\/|search\\/)([-\\w]+\\/[-\\w]+)/,m]],[]],podbean:[[[/podbean\\.com\\/(?:[-\\w]+\\/)*(?:player[-\\w]*\\/|\\w+\\/pb-)([-\\w]+)/,m]],[{a:[[/podbean\\.com\\/player[^\\/]*\\/\\?i=([-\\w]+)/,m]],match:[[/podbean\\.com\\/(?:media\\/shar)?e\\/(?!pb-)/,c]]}]],prezi:[[[/\\/\\/prezi\\.com\\/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)\\/)(\\w+)\\//,
m]],[]],reddit:[[[/(\\w+\\/comments\\/\\w+(?:\\/\\w+\\/\\w+)?)/,m]],[]],rumble:[[[/rumble\\.com\\/embed\\/(\\w+)/,m]],[{a:[[/video"?:"(\\w+)/,m]],match:[[/rumble\\.com\\/(?!embed\\/)./,c]]}]],rutube:[[[/rutube\\.ru\\/(?:play\\/embed\\/|tracks\\/.*?v=|video\\/)(\\w+)/,m]],[]],scribd:[[[/scribd\\.com\\/(?:mobile\\/)?(?:doc(?:ument)?|presentation)\\/(\\d+)/,m]],[]],sendvid:[[[/sendvid\\.com\\/(\\w+)/,m]],[]],slideshare:[[[/slideshare.net\\/slideshow\\/embed_code\\/key\\/(\\w+)$/,aa]],[{a:[[/embed_code\\/key\\/(\\w+)/,aa],[/data-slideshow-id="(\\d+)"/,
m]],match:[[/slideshare\\.net\\/[^\\/]+\\/\\w(?![-\\w]+-\\d{6,}$)/,c]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,m],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,z],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists\\/|tracks\\/)[-\\w]+\\/(?:sets\\/)?[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{a:[[/soundcloud(?::\\/)?:tracks:(\\d+)/,y]],r:"User-agent: PHP (not Mozilla)",
match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,c]]},{a:[[/soundcloud(?::\\/)?\\/playlists:(\\d+)/,z]],r:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/[-\\w]+\\/sets\\//,c]]}]],sporcle:[[[/sporcle.com\\/framed\\/.*?gid=(\\w+)/,m]],[{a:[[/encodedGameID\\W+(\\w+)/,m]],match:[[/sporcle\\.com\\/games\\/(?!\\w*category\\/)[-\\w]+\\/[-\\w]/,c]]}]],sportsnet:[[],[{a:[[/bc_videos\\s*:\\s*(\\d+)/,m]],match:ea}]],spotify:[Da,[{a:Da,r:"User-agent: PHP (not Mozilla)",match:[[/link\\.tospotify\\.com\\/./,
c]]}]],spreaker:[[[/spreaker\\.com\\/episode\\/(\\d+)/,na]],[{a:[[/episode_id=(\\d+)/,na],[/show_id=(\\d+)/,ca]],match:[[/(.+\\/(?:show\\/|user\\/.+\\/).+)/,["","url"]]],n:"https://api.spreaker.com/oembed?format=json&url={@url}"}]],steamstore:[[[/store.steampowered.com\\/app\\/(\\d+)/,m]],[]],stitcher:[[[/\\/(?:embed|splayer\\/f)\\/(\\d+)\\/(\\d+)/,ma]],[{a:[[/\\/embed\\/(\\d+)\\/(\\d+)/,ma]],match:[[/\\/(?:podcast\\/|show\\/|s\\?)/,c]]}]],strawpoll:[[[/strawpoll\\.me\\/(\\d+)/,m]],[]],streamable:[[[/streamable\\.com\\/(?:e\\/)?(\\w+)/,
m]],[]],streamja:[[[/streamja\\.com\\/(?!login|signup|terms|videos)(\\w+)/,m]],[]],teamcoco:[[[/teamcoco\\.com\\/video\\/(\\d+)/,m]],[{a:[[/embed\\/v\\/(\\d+)/,m]],match:[[/teamcoco\\.com\\/video\\/\\D/,c]]}]],ted:[[[/ted\\.com\\/((?:talk|playlist)s\\/[-\\w]+(?:\\.html)?)(?![-\\w]|\\/transcript)/i,m]],[]],telegram:[[[/\\/\\/t.me\\/(?!addstickers\\/|joinchat\\/)(?:s\\/)?(\\w+\\/\\d+)/,m]],[]],theatlantic:[[[/theatlantic\\.com\\/video\\/index\\/(\\d+)/,m]],[]],theguardian:[[[/theguardian\\.com\\/(\\w+\\/video\\/20(?:0[0-9]|1[0-7])[-\\/\\w]+)/,
m]],[]],theonion:[[[/theonion\\.com\\/video\\/[-\\w]+[-,](\\d+)/,m]],[]],tiktok:[[[/tiktok\\.com\\/(?:@[.\\w]+\\/video|v|(?:i18n\\/)?share\\/video)\\/(\\d+)/,m]],[{a:[[/tiktok\\.com\\/(?:@[.\\w]+\\/video|v|(?:i18n\\/)?\\/share\\/video)\\/(\\d+)/,m]],match:[[/\\/\\/v[mt]\\.tiktok\\.com\\/(\\w+)/,ha],[/tiktok\\.com\\/t\\/(\\w+)/,ha]],n:"https://www.tiktok.com/t/{@short_id}"}]],tmz:[[[/tmz\\.com\\/videos\\/(\\w+)/,m]],[]],tradingview:[[[/tradingview\\.com\\/(?:chart\\/[^\\/]+|i)\\/(\\w+)/,["","chart"]],[/tradingview\\.com\\/symbols\\/([-:\\w]+)/,
["","symbol"]]],[]],traileraddict:[[],[{a:[[/v\\.traileraddict\\.com\\/(\\d+)/,m]],match:[[/traileraddict\\.com\\/(?!tags\\/)[^\\/]+\\/./,c]]}]],trendingviews:[[[/(?:mydailyfreedom\\.com|trendingviews\\.co)\\/(?:tv\\/)?(?:embed|video)\\/(?:[^\\/]+-)?(\\d+)/,m]],[]],tumblr:[[[/([-\\w]+)\\.tumblr\\.com\\/post\\/(\\d+)/,la],[/(?:at|www)\\.tumblr\\.com\\/([-\\w]+)\\/(\\d+)/,la]],[{a:[[/did=(?:\\\\"|\\\\u0022)([-\\w]+)/,["","did"]],[/embed\\/post\\/t:([-\\w]+)/,aa]],r:"User-agent: curl",match:[[/\\w\\.tumblr\\.com\\/post\\/\\d/,c],[/(?:at|www)\\.tumblr\\.com\\/[-\\w]+\\/\\d+/,
c]],n:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}"}]],twentyfoursevensports:[Ba,[{a:Ba,r:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Player\\/[-\\w]*\\d/,c]]},{a:[[/embedVideoContainer_(\\d+)/,fa]],r:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36",match:[[/247sports\\.com\\/Video\\/./,c]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,
fa],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)(?:\\/clip\\/([-\\w]+))?/,ta],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,f],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?([-\\w]+)/,ta]],[]],twitter:[[[/twitter\\.com\\/(?:#!\\/|i\\/)?\\w+\\/(?:status(?:es)?|tweet)\\/(\\d+)/,m]],[]],ustream:[[[/ustream\\.tv\\/recorded\\/(\\d+)/,["","vid"]]],[{a:[[/embed\\/(\\d+)/,["","cid"]]],match:[[/ustream\\.tv\\/(?!explore\\/|platform\\/|recorded\\/|search\\?|upcoming$|user\\/)(?:channel\\/)?[-\\w]+/,c]]}]],vbox7:[[[/vbox7\\.com\\/play:([\\da-f]+)/,m]],[]],veoh:[[[/veoh\\.com\\/(?:m\\/watch\\.php\\?v=|watch\\/)v(\\w+)/,
m]],[]],vevo:[[[/vevo\\.com\\/watch\\/(.*?\\/)?([A-Z]+\\d+)/,["","","id"]]],[]],videodetective:[[[/videodetective\\.com\\/\\w+\\/[-\\w]+\\/(?:trailer\\/P0*)?(\\d+)/,m]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)(?:\\/(\\w+))?\\b/,["","id","h"]],[/#t=([\\dhms]+)/,f]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,m]],[]],vk:[[[/vk(?:\\.com|ontakte\\.ru)\\/(?:[\\w.]+\\?z=)?video(-?\\d+)_(\\d+).*?hash=([0-9a-f]+)/,sa],[/vk(?:\\.com|ontakte\\.ru)\\/video_ext\\.php\\?oid=(-?\\d+)&id=(\\d+)&hash=([0-9a-f]+)/,sa]],[{a:[[/meta property="og:video" content=".*?oid=(-?\\d+).*?id=(\\d+).*?hash=([0-9a-f]+)/,
sa]],r:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0",match:[[/^(?!.*?hash=)/,c]]}]],vocaroo:[[[/voca(?:\\.ro|roo\\.com)\\/(?:i\\/)?(\\w+)/,m]],[]],vox:[[[/vox.com\\/.*#ooid=([-\\w]+)/,m]],[]],washingtonpost:[[[/washingtonpost\\.com\\/video\\/c\\/\\w+\\/([-0-9a-f]+)/,m],[/washingtonpost\\.com\\/video\\/[-\\/\\w]+\\/([-0-9a-f]+)_video\\.html/,m]],[]],wavekit:[[[/play\\.wavekit\\.app\\/(?:embed|share)\\/audio\\/(\\w+)/,["","audio_id"]],[/play\\.wavekit\\.app\\/(?:embed|share)\\/playlist\\/(\\w+)/,
z]],[]],wistia:[[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)(\\w+)/,m]],[{a:[[/"type":"(?:\\w+_)?(audio)/,p]],match:[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)\\w/,c]],n:"https://fast.wistia.net/embed/iframe/{@id}"}]],wshh:[[[/worldstar(?:hiphop)?\\.com\\/(?:emb|featur)ed\\/(\\d+)/,m]],[{a:[[/(?:v: ?"?|worldstar(?:hiphop)?\\.com\\/embed\\/)(\\d+)/,m]],match:[[/worldstar(?:hiphop)?\\.com\\/(?:\\w+\\/)?video\\.php\\?v=\\w+/,c]]}]],wsj:[[[/wsj\\.com\\/[^#]*#!([-0-9A-F]{36})/,m],[/wsj\\.com\\/video\\/[^\\/]+\\/([-0-9A-F]{36})/,
m]],[{a:[[/guid=([-0-9A-F]{36})/,m]],match:[[/on\\.wsj\\.com\\/\\w/,c]]}]],xboxclips:[[[/(?:gameclips\\.io|xboxclips\\.com)\\/(?!game\\/)([^\\/]+)\\/(?!screenshots\\/)([-0-9a-f]+)/,ia]],[]],xboxdvr:[[[/(?:gamer|xbox)dvr\\.com\\/gamer\\/([^\\/]+)\\/video\\/(\\d+)/,ia]],[]],youku:[[[/youku\\.com\\/v(?:_show|ideo)\\/id_(\\w+=*)/,m]],[]],youmaker:[[[/youmaker\\.com\\/(?:embed|v(?:ideo)?)\\/([-a-z0-9]+)/i,m]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|(?:embed|live|shorts|v)\\/|attribution_link.*?v%3D)([-\\w]+)/,m],[/youtu\\.be\\/([-\\w]+)/,
m],[/[#&?]t=(\\d[\\dhms]*)/,f],[/[&?]list=([-\\w]+)/,["","list"]]],[]]},urlConfig:{F:/^https?$/i}},bb={e:[771],flags:0},U={ABCNEWS:I,ACAST:{e,b:{episode_id:B,show_id:B,t:B},j:1,d:F,f:10,k:t,g:5E3},AMAZON:{e,b:{id:C,tld:B},j:1,d:F,f:10,k:t,g:5E3},ANCHOR:I,APPLEPODCASTS:{e,b:{country:B,episode_id:B,podcast_id:B},j:1,d:F,f:10,k:t,g:5E3},AUDIOBOOM:I,AUDIOMACK:{e,b:{artist:B,mode:B,title:B},j:1,d:F,f:10,k:t,g:5E3},AUDIUS:{e,b:{album_id:B,playlist_id:B,track_id:B},j:1,d:F,f:10,k:t,g:5E3},BANDCAMP:{e,b:{album_id:B,
track_id:B,track_num:B},j:1,d:F,f:10,k:t,g:5E3},BBCNEWS:I,BITCHUTE:I,BLEACHERREPORT:I,BRIGHTCOVE:{e,b:{bckey:B,bcpid:B,bctid:B},j:1,d:F,f:10,k:t,g:5E3},BUNNY:{e,b:{video_id:B,video_library_id:B},j:1,d:F,f:10,k:t,g:5E3},CASTOS:{e,b:{host:B,id:B},j:1,d:F,f:10,k:t,g:5E3},CBSNEWS:I,CLYP:I,CNBC:I,CNN:I,CNNMONEY:I,CODEPEN:Na,COMEDYCENTRAL:I,COUB:I,DAILYMOTION:{e,b:{id:B,t:B},j:1,d:F,f:10,k:t,g:5E3},DEMOCRACYNOW:I,DUMPERT:I,EIGHTTRACKS:I,ESPN:I,FACEBOOK:{e,b:{id:B,page_id:B,pfbid:B,type:B,user:B},j:1,d:F,
f:10,k:t,g:5E3},FALSTAD:{e,b:{cct:B,ctz:B},j:1,d:F,f:10,k:t,g:5E3},FLICKR:I,FOXNEWS:I,FUNNYORDIE:I,GAMESPOT:I,GETTY:{e,b:{et:C,height:Ha,id:B,sig:C,width:Ia},j:1,d:F,f:10,k:t,g:5E3},GFYCAT:Oa,GIFS:Oa,GIPHY:{e,b:{height:Ha,id:B,type:B,width:Ia},j:1,d:F,f:10,k:t,g:5E3},GIST:I,GLOBALNEWS:I,GOFUNDME:I,GOOGLEDRIVE:I,GOOGLEPLUS:{e,b:{name:{d:[function(a){return decodeURIComponent(""+a)}],s:!1},oid:B,pid:B},j:1,d:F,f:10,k:t,g:5E3},GOOGLESHEETS:{e,b:{gid:B,id:B,oid:B,type:B},j:1,d:F,f:10,k:t,g:5E3},HUDL:{e,
b:{athlete:B,highlight:B,id:B},j:1,d:F,f:10,k:t,g:5E3},HULU:I,IGN:I,IMDB:I,IMGUR:I,INDIEGOGO:I,INSTAGRAM:I,INTERNETARCHIVE:{e,b:{height:Ha,id:{d:[function(){return!1}],s:!1},width:Ia},j:1,d:F,f:10,k:t,g:5E3},IZLESENE:I,JSFIDDLE:{e,b:{id:B,revision:B,user:B},j:1,d:F,f:10,k:t,g:5E3},JWPLATFORM:I,KALTURA:{e,b:{entry_id:C,partner_id:C,sp:B,uiconf_id:C},j:1,d:F,f:10,k:t,g:5E3},KHL:I,KICKSTARTER:{e,b:{card:B,id:B,video:B},j:1,d:F,f:10,k:t,g:5E3},LIBSYN:I,LIVELEAK:I,LIVESTREAM:{e,b:{account_id:B,channel:B,
clip_id:B,event_id:B,video_id:B},j:1,d:F,f:10,k:t,g:5E3},MAILRU:I,MASTODON:{e,b:{host:C,id:B,name:B},j:1,d:F,f:10,k:t,g:5E3},MEDIA:{e:[770],b:{},j:0,d:[function(a){return function(b,d,g){function n(k,h,l){let r=!1;l.forEach(u=>{let w=u[1],x=u[0].exec(h);x&&(r=!0,w.forEach((H,A)=>{""<x[A]&&""<H&&(k[H]=x[A])}))});return r}(function(k,h,l){E(k);if("url"in k.b){var r=k.b.url;a:{for(var u=/^https?:\\/\\/([^\\/]+)/.exec(r.toLowerCase())[1]||"";""<u;){if(h[u]){h=h[u];break a}u=u.replace(/^[^.]*./,"")}h=""}if(l[h]){u=
{};n(u,r,l[h][0]);l=u;a:{for(w in l){var w=!1;break a}w=!0}if(!w){u=k.l;r=k.v;if(r){var x=k.o;w=r.l;r=r.o}else x=0,w=k.l+k.o,r=0;h=h.toUpperCase();k=k.x;w=R(2,h,w,r,-k||0);k=R(1,h,u,x,k||0);Wa(k,w);Fa(k,l)}}}})(b,d,g)}(a,G["MediaEmbed.hosts"],G["MediaEmbed.sites"],G.cacheDir)}],f:10,k:{flags:513},g:5E3},MEDIUM:I,MEGAPHONE:I,METACAFE:I,MIXCLOUD:I,MLB:I,MRCTV:I,MSNBC:I,NATGEOCHANNEL:I,NATGEOVIDEO:I,NBCNEWS:I,NBCSPORTS:I,NHL:{e,b:{c:B,t:B},j:1,d:F,f:10,k:t,g:5E3},NPR:{e,b:{i:B,m:B},j:1,d:F,f:10,k:t,
g:5E3},NYTIMES:I,ODYSEE:{e,b:{id:B,name:Ma,path:Ma},j:1,d:F,f:10,k:t,g:5E3},ORFIUM:{e,b:{album_id:B,playlist_id:B,set_id:B,track_id:B},j:1,d:F,f:10,k:t,g:5E3},PASTEBIN:I,PINTEREST:I,PODBEAN:I,PREZI:I,REDDIT:I,RUMBLE:I,RUTUBE:I,SCRIBD:I,SENDVID:I,SLIDESHARE:{e,b:{id:B,key:C},j:1,d:F,f:10,k:t,g:5E3},SOUNDCLOUD:{e,b:{id:B,playlist_id:B,secret_token:B,track_id:B},j:1,d:F,f:10,k:t,g:5E3},SPORCLE:I,SPORTSNET:I,SPOTIFY:I,SPREAKER:{e,b:{episode_id:B,show_id:B},j:1,d:F,f:10,k:t,g:5E3},STEAMSTORE:I,STITCHER:{e,
b:{eid:B,fid:B},j:1,d:F,f:10,k:t,g:5E3},STRAWPOLL:I,STREAMABLE:I,STREAMJA:I,TEAMCOCO:I,TED:I,TELEGRAM:I,THEATLANTIC:I,THEGUARDIAN:I,THEONION:I,TIKTOK:I,TMZ:I,TRADINGVIEW:{e,b:{chart:B,symbol:B},j:1,d:F,f:10,k:t,g:5E3},TRAILERADDICT:I,TRENDINGVIEWS:I,TUMBLR:{e,b:{did:C,id:B,key:C,name:C},j:1,d:F,f:10,k:t,g:5E3},TWENTYFOURSEVENSPORTS:{e,b:{player_id:B,video_id:B},j:1,d:F,f:10,k:t,g:5E3},TWITCH:{e,b:{channel:B,clip_id:B,t:B,video_id:B},j:1,d:F,f:10,k:t,g:5E3},TWITTER:I,USTREAM:{e,b:{cid:B,vid:B},j:1,
d:F,f:10,k:t,g:5E3},VBOX7:I,VEOH:I,VEVO:I,VIDEODETECTIVE:I,VIMEO:{e,b:{h:B,id:B,t:Ga},j:1,d:F,f:10,k:t,g:5E3},VINE:I,VK:{e,b:{hash:B,oid:B,vid:B},j:1,d:F,f:10,k:t,g:5E3},VOCAROO:I,VOX:I,WASHINGTONPOST:I,WAVEKIT:{e,b:{audio_id:B,playlist_id:B},j:1,d:F,f:10,k:t,g:5E3},WISTIA:{e,b:{id:B,type:B},j:1,d:F,f:10,k:t,g:5E3},WSHH:I,WSJ:I,XBOXCLIPS:Na,XBOXDVR:Na,YOUKU:I,YOUMAKER:I,YOUTUBE:{e,b:{id:{d:[function(a){return/^[-0-9A-Za-z_]+$/.test(a)?a:!1}],s:!1},list:B,t:Ga},j:1,d:F,f:10,k:t,g:5E3}};
let V,cb,W,X,db=0,Y;
function eb(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\uFFFE\\uFFFF]/g,"");var b=D;b.u=[];delete b.l;delete b.o;L={};$a={};N=0;O=null;ab=!1;P=[];Q="";T=0;V=[];cb=!1;W=a;X=W.length;Y=0;M=bb;M.A=!1;++db;a=db;for(var d in S)if(!S[d].w)a:{b=d;var g=S[b];if(!(g.B&&0>W.indexOf(g.B))){var n=[];if("undefined"!==typeof g.C&&"undefined"!==typeof g.D){let k=void 0;n=g.C;g=g.D;n.lastIndex=0;let h=[],l=0;for(;++l<=g&&(k=n.exec(W));){let r=k.index,u=[[k[0],r]],w=0;for(;++w<k.length;){let x=
k[w];void 0===x?u.push(["",-1]):(u.push([x,W.indexOf(x,r)]),r+=x.length)}h.push(u)}n=h;if(!n.length)break a}(0,S[b].I)(W,n)}}fb();Z(X,!0);do d=Q,Q=Q.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(Q!==d);Q=Q.replace(/<\\/i><i>/g,"");Q=Q.replace(/[\\x00-\\x08\\x0B-\\x1F\\uFFFE\\uFFFF]/g,"");Q=Q.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,gb);d=ab?"r":"t";Q="<"+d+">"+Q+"</"+d+">";if(db!==a)throw"The parser has been reset during execution";1E4<N&&D.add("warn","Fixing cost limit exceeded",void 0);return Q}
function hb(a){let b={},d;for(d in U[a])b[d]=U[a][d];return U[a]=b}function gb(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function ib(a){ab=!0;let b=a.name,d=a.l,g=a.o,n=0;Z(d,!(a.q&1));let k=g?Ta(W.substring(d,d+g)):"";if(a.q&1){Q+="<"+b;let h=Ya(a),l=[];for(let r in h)l.push(r);l.sort((r,u)=>r>u?1:-1);l.forEach(r=>{Q+=" "+r+\'="\'+Sa(h[r].toString()).replace(/\\n/g,"&#10;")+\'"\'});Q=3===a.q?g?Q+(">"+k+"</"+b+">"):Q+"/>":g?Q+("><s>"+k+"</s>"):Q+">"}else g&&(Q+="<e>"+k+"</e>"),Q+="</"+b+">";for(Y=T=d+g;n&&Y<X&&"\\n"===W[Y];)--n,++Y}
function Z(a,b){var d=0;b&&(M.flags&8?d=-1:b=!1);T>=a&&b&&jb();if(Y>T){var g=Math.min(a,Y);Q+=W.substring(T,g);T=g;T>=a&&b&&jb()}let n=a;for(g=0;d&&--n>=T;){let k=W[n];if(" "!==k&&"\\n"!==k&&"\\t"!==k)break;"\\n"===k&&--d;++g}a-=g;a>T&&(d=Ta(W.substring(T,a)),Q+=d);b&&jb();g&&(Q+=W.substring(a,a+g));T=a+g}function kb(a){let b=a.l;a=a.o;let d=W.substring(b,b+a);Z(b,!1);Q+="<i>"+Ta(d)+"</i>";ab=!0;T=b+a}function jb(){M.A&&(Q+="</p>",M.A=!1)}
function fb(){if(V.length){for(let a in U)L[a]=0,$a[a]=0;do{for(;V.length;)cb||lb(),O=V.pop(),mb();P.forEach(a=>{let b=R(2,a.name,X,0,0);Wa(b,a)})}while(V.length)}}
function mb(){M.flags&64&&!Za(O,P[P.length-1])&&!(-1<"br i pb v".indexOf(O.name))&&E(O);var a=O.l,b=O.o;if(T>a&&!O.p){var d;if((d=O.u)&&0<=P.indexOf(d)){Wa(R(2,d.name,T,Math.max(0,a+b-T),0),d);return}if("i"===O.name&&(b=a+b-T,0<b)){a=T;R(3,"i",a,Math.min(b,X-a),0);return}E(O)}if(!O.p)if("i"===O.name)kb(O);else if("br"===O.name)M.flags&1024||(Z(O.l,!1),Q+="<br/>");else if("pb"===O.name)Z(O.l,!0);else if("v"===O.name)a=M.flags,M.flags=O.flags,Z(O.l+O.o,!1),M.flags=a;else if(O.q&1){a=O;b=a.name;let g=
U[b];if($a[b]>=g.g)D.add("err","Tag limit exceeded",{tag:a,tagName:b,tagLimit:g.g}),E(a);else{d=a;let n=U[d.name];D.o=d;for(let k=0;k<n.d.length&&!d.p;++k)n.d[k](d,n);delete D.o;a.p||(L[b]>=g.f?(D.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:g.f}),E(a)):(d=U[b].j,M.e[d>>3]&1<<(d&7)?(!(a.flags&1&&3!==a.q)||a.v||V.length&&Za(V[V.length-1],a)||(b=new K(3,b,a.l,a.o),Fa(b,Ya(a)),b.flags=a.flags,a=b),ib(a),nb(a)):(b={tag:a,tagName:b},0<a.o?D.add("warn","Tag is not allowed in this context",
b):Va("Tag is not allowed in this context",b),E(a))))}}else ob()}
function ob(){var a=O;if(L[a.name]){for(var b=[],d=P.length;0<=--d;){var g=P[d];if(Za(a,g))break;b.push(g);++N}if(0>d)Va("Skipping end tag with no start tag",{tag:a});else{b.forEach(()=>{});var n=0,k=[];b.forEach(h=>{var l=h.name;n&&(h.flags&2?k.push(h):n=!1);l=new K(2,l,a.l,0);l.flags=h.flags;ib(l);pb()});ib(a);pb();if(b.length&&1E4>N){g=T;for(d=V.length;0<=--d&&1E4>++N;){let h=V[d];if(h.l>g||h.q&1)break;let l=b.length;for(;0<=--l&&1E4>++N;)if(Za(h,b[l])){b.splice(l,1);k[l]&&k.splice(l,1);g=Math.max(g,
h.l+h.o);break}}g>T&&kb(new K(3,"i",T,g-T))}k.forEach(h=>{let l=R(h.q,h.name,T,0,h.x);Fa(l,Ya(h));(h=h.v)&&Wa(l,h)})}}}function pb(){let a=P.pop();--L[a.name];M=M.H}function nb(a){let b=a.name,d=a.flags,g=U[b];++$a[b];if(3!==a.q){var n=[];M.e.forEach((h,l)=>{d&512||(h=h&65280|h>>8);n.push(g.e[l]&h)});var k=d|M.flags&32;k&16&&(k&=-33);++L[b];P.push(a);M={H:M};M.e=n;M.flags=k}}
function R(a,b,d,g,n){a=new K(a,b,d,g,n||0);U[b]&&(a.flags=U[b].k.flags);if(!(U[b]||-1<"br i pb v".indexOf(a.name))||0>g||0>d||d+g>X||/[\\uDC00-\\uDFFF]/.test(W.substring(d,d+1)+W.substring(d+g,d+g+1)))E(a);else if(U[b]&&U[b].w)D.add("warn","Tag is disabled",{tag:a,tagName:b}),E(a);else if(cb){b=V.length;for(d=qb(a);0<b&&d>qb(V[b-1]);)V[b]=V[b-1],--b;V[b]=a}else V.push(a);return a}
function lb(){let a={},b=[],d=V.length;for(;0<=--d;){let g=V[d],n=qb(g,d);b.push(n);a[n]=g}b.sort();d=b.length;for(V=[];0<=--d;)V.push(a[b[d]]);cb=!0}function qb(a,b){let d=0<=a.x,g=a.x;d||(g+=1073741824);let n=0<a.o,k;n?k=X-a.o:k={2:0,3:1,1:2}[a.q];return rb(a.l)+ +d+rb(g)+ +n+rb(k)+rb(b||0)}function rb(a){a=a.toString(16);return"        ".substring(a.length)+a}function sb(a){const b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}
function tb(a,b){return ub.transformToFragment(sb(a),b)}var ub;ub=new XSLTProcessor;ub.importStylesheet(sb(Pa));window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){S[a]&&(S[a].w=!0)},disableTag:function(a){U[a]&&(hb(a).w=!0)},enablePlugin:function(a){S[a]&&(S[a].w=!1)},enableTag:function(a){U[a]&&(hb(a).w=!1)},getLogger:function(){return D},parse:eb,preview:function(a,b){function d(h,l){var r=h.childNodes;l=l.childNodes;var u=r.length,w=l.length;let x,H,A=0,J=0;for(;A<u&&A<w;){x=r[A];H=l[A];if(!g(x,H))break;++A}let vb=Math.min(u-A,w-A);for(;J<vb;){x=r[u-(J+1)];H=l[w-(J+1)];if(!g(x,H))break;++J}for(u-=J;--u>=
A;)h.removeChild(r[u]),k=h;r=w-J;if(!(A>=r)){w=n.createDocumentFragment();u=A;do H=l[u],k=w.appendChild(H);while(u<--r);J?h.insertBefore(w,h.childNodes[A]):h.appendChild(w)}}function g(h,l){if(h.nodeName!==l.nodeName||h.nodeType!==l.nodeType)return!1;if(h instanceof HTMLElement&&l instanceof HTMLElement){if(!h.isEqualNode(l)){var r=h.attributes;let H=l.attributes;var u=H.length;let A=r.length,J=" "+h.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";for(;0<=--A;){var w=r[A],x=w.namespaceURI;w=
w.name;-1<J.indexOf(" "+w+" ")||l.hasAttributeNS(x,w)||(h.removeAttributeNS(x,w),k=h)}for(A=u;0<=--A;)x=H[A],r=x.namespaceURI,u=x.name,x=x.value,-1<J.indexOf(" "+u+" ")||x===h.getAttributeNS(r,u)||(h.setAttributeNS(r,u,x),k=h);d(h,l)}}else 3!==h.nodeType&&8!==h.nodeType||h.nodeValue===l.nodeValue||(h.nodeValue=l.nodeValue,k=h);return!0}let n=b.ownerDocument;if(!n)throw"Target does not have a ownerDocument";a=tb(eb(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),n);let k=b;"undefined"!==typeof window&&"chrome"in
window&&a.querySelectorAll("script").forEach(function(h){let l=document.createElement("script");for(let r of h.attributes)l.setAttribute(r.name,r.value);l.textContent=h.textContent;h.parentNode.replaceChild(l,h)});d(b,a);return k},registeredVars:G,setNestingLimit:function(a,b){U[a]&&(hb(a).f=b)},setParameter:function(a,b){ub.setParameter(null,a,b)},setTagLimit:function(a,b){U[a]&&(hb(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser()
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:1:{s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:16:"MediaEmbed.hosts";a:178:{s:14:"abcnews.go.com";s:7:"abcnews";s:9:"acast.com";s:5:"acast";s:9:"amazon.ca";s:6:"amazon";s:12:"amazon.co.uk";s:6:"amazon";s:12:"amazon.co.jp";s:6:"amazon";s:10:"amazon.com";s:6:"amazon";s:9:"amazon.de";s:6:"amazon";s:9:"amazon.es";s:6:"amazon";s:9:"amazon.fr";s:6:"amazon";s:9:"amazon.in";s:6:"amazon";s:9:"amazon.it";s:6:"amazon";s:9:"anchor.fm";s:6:"anchor";s:18:"podcasts.apple.com";s:13:"applepodcasts";s:11:"audioboo.fm";s:9:"audioboom";s:13:"audioboom.com";s:9:"audioboom";s:13:"audiomack.com";s:9:"audiomack";s:9:"audius.co";s:6:"audius";s:12:"bandcamp.com";s:8:"bandcamp";s:9:"bbc.co.uk";s:7:"bbcnews";s:7:"bbc.com";s:7:"bbcnews";s:12:"bitchute.com";s:8:"bitchute";s:18:"bleacherreport.com";s:14:"bleacherreport";s:19:"link.brightcove.com";s:10:"brightcove";s:22:"players.brightcove.net";s:10:"brightcove";s:24:"iframe.mediadelivery.net";s:5:"bunny";s:18:"video.bunnycdn.com";s:5:"bunny";s:10:"castos.com";s:6:"castos";s:11:"cbsnews.com";s:7:"cbsnews";s:7:"clyp.it";s:4:"clyp";s:8:"cnbc.com";s:4:"cnbc";s:7:"cnn.com";s:3:"cnn";s:13:"money.cnn.com";s:8:"cnnmoney";s:10:"codepen.io";s:7:"codepen";s:6:"cc.com";s:13:"comedycentral";s:17:"comedycentral.com";s:13:"comedycentral";s:8:"coub.com";s:4:"coub";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:16:"democracynow.org";s:12:"democracynow";s:10:"dumpert.nl";s:7:"dumpert";s:11:"8tracks.com";s:11:"eighttracks";s:8:"espn.com";s:4:"espn";s:11:"espn.go.com";s:4:"espn";s:12:"facebook.com";s:8:"facebook";s:8:"fb.watch";s:8:"facebook";s:11:"falstad.com";s:7:"falstad";s:7:"flic.kr";s:6:"flickr";s:10:"flickr.com";s:6:"flickr";s:17:"video.foxnews.com";s:7:"foxnews";s:14:"funnyordie.com";s:10:"funnyordie";s:12:"gamespot.com";s:8:"gamespot";s:14:"gettyimages.be";s:5:"getty";s:14:"gettyimages.cn";s:5:"getty";s:17:"gettyimages.co.jp";s:5:"getty";s:17:"gettyimages.co.uk";s:5:"getty";s:15:"gettyimages.com";s:5:"getty";s:18:"gettyimages.com.au";s:5:"getty";s:14:"gettyimages.de";s:5:"getty";s:14:"gettyimages.dk";s:5:"getty";s:14:"gettyimages.es";s:5:"getty";s:14:"gettyimages.fr";s:5:"getty";s:14:"gettyimages.ie";s:5:"getty";s:14:"gettyimages.it";s:5:"getty";s:14:"gettyimages.nl";s:5:"getty";s:14:"gettyimages.pt";s:5:"getty";s:14:"gettyimages.se";s:5:"getty";s:6:"gty.im";s:5:"getty";s:10:"gfycat.com";s:6:"gfycat";s:8:"gifs.com";s:4:"gifs";s:9:"giphy.com";s:5:"giphy";s:10:"github.com";s:4:"gist";s:13:"globalnews.ca";s:10:"globalnews";s:12:"gofundme.com";s:8:"gofundme";s:16:"drive.google.com";s:11:"googledrive";s:15:"plus.google.com";s:10:"googleplus";s:15:"docs.google.com";s:12:"googlesheets";s:8:"hudl.com";s:4:"hudl";s:8:"hulu.com";s:4:"hulu";s:7:"ign.com";s:3:"ign";s:8:"imdb.com";s:4:"imdb";s:9:"imgur.com";s:5:"imgur";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:11:"archive.org";s:15:"internetarchive";s:12:"izlesene.com";s:8:"izlesene";s:12:"jsfiddle.net";s:8:"jsfiddle";s:14:"jwplatform.com";s:10:"jwplatform";s:11:"kaltura.com";s:7:"kaltura";s:12:"video.khl.ru";s:3:"khl";s:15:"kickstarter.com";s:11:"kickstarter";s:10:"libsyn.com";s:6:"libsyn";s:12:"liveleak.com";s:8:"liveleak";s:11:"livestre.am";s:10:"livestream";s:14:"livestream.com";s:10:"livestream";s:10:"my.mail.ru";s:6:"mailru";s:15:"mastodon.social";s:8:"mastodon";s:10:"medium.com";s:6:"medium";s:12:"megaphone.fm";s:9:"megaphone";s:14:"megaphone.link";s:9:"megaphone";s:12:"metacafe.com";s:8:"metacafe";s:12:"mixcloud.com";s:8:"mixcloud";s:7:"mlb.com";s:3:"mlb";s:9:"mrctv.org";s:5:"mrctv";s:9:"msnbc.com";s:5:"msnbc";s:30:"channel.nationalgeographic.com";s:13:"natgeochannel";s:28:"video.nationalgeographic.com";s:11:"natgeovideo";s:11:"nbcnews.com";s:7:"nbcnews";s:13:"nbcsports.com";s:9:"nbcsports";s:7:"nhl.com";s:3:"nhl";s:7:"npr.org";s:3:"npr";s:4:"n.pr";s:3:"npr";s:11:"nytimes.com";s:7:"nytimes";s:10:"odysee.com";s:6:"odysee";s:10:"orfium.com";s:6:"orfium";s:12:"pastebin.com";s:8:"pastebin";s:13:"pinterest.com";s:9:"pinterest";s:11:"podbean.com";s:7:"podbean";s:9:"prezi.com";s:5:"prezi";s:10:"reddit.com";s:6:"reddit";s:10:"rumble.com";s:6:"rumble";s:9:"rutube.ru";s:6:"rutube";s:10:"scribd.com";s:6:"scribd";s:11:"sendvid.com";s:7:"sendvid";s:14:"slideshare.net";s:10:"slideshare";s:14:"soundcloud.com";s:10:"soundcloud";s:11:"sporcle.com";s:7:"sporcle";s:12:"sportsnet.ca";s:9:"sportsnet";s:18:"link.tospotify.com";s:7:"spotify";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:12:"spreaker.com";s:8:"spreaker";s:22:"store.steampowered.com";s:10:"steamstore";s:12:"stitcher.com";s:8:"stitcher";s:12:"strawpoll.me";s:9:"strawpoll";s:14:"streamable.com";s:10:"streamable";s:12:"streamja.com";s:8:"streamja";s:12:"teamcoco.com";s:8:"teamcoco";s:7:"ted.com";s:3:"ted";s:4:"t.me";s:8:"telegram";s:15:"theatlantic.com";s:11:"theatlantic";s:15:"theguardian.com";s:11:"theguardian";s:12:"theonion.com";s:8:"theonion";s:10:"tiktok.com";s:6:"tiktok";s:7:"tmz.com";s:3:"tmz";s:15:"tradingview.com";s:11:"tradingview";s:17:"traileraddict.com";s:13:"traileraddict";s:18:"mydailyfreedom.com";s:13:"trendingviews";s:16:"trendingviews.co";s:13:"trendingviews";s:10:"tumblr.com";s:6:"tumblr";s:13:"247sports.com";s:21:"twentyfoursevensports";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:10:"ustream.tv";s:7:"ustream";s:9:"vbox7.com";s:5:"vbox7";s:8:"veoh.com";s:4:"veoh";s:8:"vevo.com";s:4:"vevo";s:18:"videodetective.com";s:14:"videodetective";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:6:"vk.com";s:2:"vk";s:12:"vkontakte.ru";s:2:"vk";s:7:"voca.ro";s:7:"vocaroo";s:11:"vocaroo.com";s:7:"vocaroo";s:7:"vox.com";s:3:"vox";s:18:"washingtonpost.com";s:14:"washingtonpost";s:16:"play.wavekit.app";s:7:"wavekit";s:10:"wistia.com";s:6:"wistia";s:13:"worldstar.com";s:4:"wshh";s:19:"worldstarhiphop.com";s:4:"wshh";s:7:"wsj.com";s:3:"wsj";s:12:"gameclips.io";s:9:"xboxclips";s:13:"xboxclips.com";s:9:"xboxclips";s:12:"gamerdvr.com";s:7:"xboxdvr";s:11:"xboxdvr.com";s:7:"xboxdvr";s:9:"youku.com";s:5:"youku";s:12:"youmaker.com";s:8:"youmaker";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:134:{s:7:"abcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:68:"!abcnews\\.go\\.com/(?:video/embed\\?id=|[^/]+/video/[^/]+-)(?\'id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}}i:1;a:0:{}}s:5:"acast";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:84:"@play\\.acast\\.com/s/(?\'show_id\'[-.\\w]+)/(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"show_id";i:2;s:10:"episode_id";i:3;s:1:"t";}}i:1;a:2:{i:0;s:97:"@shows\\.acast\\.com/(?\'show_id\'[-.\\w]+)/(?:episodes/)?(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;R:203;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:34:"@"showId":"(?\'show_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:7:"show_id";}}i:1;a:2:{i:0;s:33:"@"id":"(?\'episode_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"episode_id";}}}s:5:"match";a:2:{i:0;a:2:{i:0;s:30:"@play\\.acast\\.com/s/[-.\\w]+/.@";i:1;a:1:{i:0;s:0:"";}}i:1;a:2:{i:0;s:29:"@shows\\.acast\\.com/[-.\\w]+/.@";i:1;R:226;}}s:3:"url";s:71:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}";}}}s:6:"amazon";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#";i:1;R:195;}i:1;a:2:{i:0;s:50:"#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|in|it|jp|uk)#";i:1;a:2:{i:0;s:0:"";i:1;s:3:"tld";}}}i:1;R:198;}s:6:"anchor";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@anchor.fm/(?:[-\\w]+/)*?episodes/(?:[-\\w]+-)(?\'id\'\\w+)(?![-\\w])@";i:1;R:195;}}i:1;R:198;}s:13:"applepodcasts";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:101:"@podcasts\\.apple\\.com/(?\'country\'\\w+)/podcast/[-\\w]*/id(?\'podcast_id\'\\d+)(?:\\?i=(?\'episode_id\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"country";i:2;s:10:"podcast_id";i:3;s:10:"episode_id";}}}i:1;R:198;}s:9:"audioboom";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"!audioboo(?:\\.f|m\\.co)m/(?:boo|post)s/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:9:"audiomack";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:71:"!audiomack\\.com/(?\'mode\'album|song)/(?\'artist\'[-\\w]+)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"mode";i:2;s:6:"artist";i:3;s:5:"title";}}i:1;a:2:{i:0;s:71:"!audiomack\\.com/(?\'artist\'[-\\w]+)/(?\'mode\'album|song)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:6:"artist";i:2;s:4:"mode";i:3;s:5:"title";}}}i:1;R:198;}s:6:"audius";a:2:{i:0;R:198;i:1;a:3:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'track_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:75:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/(?!album/|playlist/)(?\'slug\'[%\\-.\\w]+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"slug";}}}s:3:"url";s:94:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}";}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'album_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:61:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/album/(?\'slug\'[%\\-.\\w]+)@";i:1;R:285;}}s:3:"url";s:100:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}";}i:2;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!"id"\\s*:\\s*"(?\'playlist_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:64:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/playlist/(?\'slug\'[%\\-.\\w]+)@";i:1;R:285;}}s:3:"url";s:103:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}";}}}s:8:"bandcamp";a:2:{i:0;R:198;i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;R:294;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;R:226;}}}i:1;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:294;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;R:279;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:226;}}}}}s:7:"bbcnews";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:67:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/(?:\\w+-)+(?\'id\'\\d+)@";i:1;R:195;}i:1;a:2:{i:0;s:68:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/embed/(?\'id\'\\w+/\\d+)@";i:1;R:195;}i:2;a:2:{i:0;s:62:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/\\w+/(?\'id\'\\d+)@";i:1;R:195;}i:3;a:2:{i:0;s:45:"@bbc\\.co(?:m|\\.uk)/news/av-embeds/(?\'id\'\\d+)@";i:1;R:195;}}i:1;R:198;}s:8:"bitchute";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"@bitchute\\.com/(?:embed|video)/(?\'id\'[-\\w]+)@";i:1;R:195;}}i:1;R:198;}s:14:"bleacherreport";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!id="video-(?\'id\'[-\\w]+)!";i:1;R:195;}i:1;a:2:{i:0;s:31:"!video_embed\\?id=(?\'id\'[-\\w]+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!/articles/.!";i:1;R:226;}}}}}s:10:"brightcove";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:107:"@link\\.brightcove\\.com/services/player/bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bckey";i:3;s:5:"bctid";}}i:1;a:2:{i:0;s:65:"@players\\.brightcove\\.net/(?\'bcpid\'\\d+)/.*?videoId=(?\'bctid\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bctid";}}}i:1;R:198;}s:5:"bunny";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"@/(?:embed|play)/(?\'video_library_id\'\\d+)/(?\'video_id\'[-\\w]+)@";i:1;a:3:{i:0;s:0:"";i:1;s:16:"video_library_id";i:2;s:8:"video_id";}}}i:1;R:198;}s:6:"castos";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:48:"@(?\'host\'[-\\w]+)\\.castos\\.com/player/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"host";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:384;s:5:"match";a:1:{i:0;a:2:{i:0;s:45:"@castos\\.com/(?:podcasts/[^/]*+/)?episodes/.@";i:1;R:226;}}}}}s:7:"cbsnews";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"#cbsnews\\.com/videos?/(?!watch/)(?\'id\'[-\\w]+)#";i:1;R:195;}i:1;a:2:{i:0;s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";i:1;R:195;}}i:1;R:198;}s:4:"clyp";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"@clyp\\.it/(?!user/)(?\'id\'\\w+)@";i:1;R:195;}}i:1;R:198;}s:4:"cnbc";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!byGuid=(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"!cnbc\\.com/video/20\\d\\d/\\d\\d/\\d\\d/\\w!";i:1;R:226;}}}}}s:3:"cnn";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:1;R:195;}i:1;a:2:{i:0;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";i:1;R:195;}}i:1;R:198;}s:8:"cnnmoney";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";i:1;R:195;}}i:1;R:198;}s:7:"codepen";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:72:"!codepen\\.io/(?\'user\'[-\\w]+)/(?:details|embed|full|live|pen)/(?\'id\'\\w+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";}}}i:1;R:198;}s:13:"comedycentral";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";i:1;R:226;}}}}}s:4:"coub";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:27:"!coub\\.com/view/(?\'id\'\\w+)!";i:1;R:195;}}i:1;R:198;}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;R:195;}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:195;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:198;}s:12:"democracynow";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!m\\.democracynow\\.org/stories/\\d!";i:1;R:226;}}}}}s:7:"dumpert";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!dumpert\\.nl/(?:item|mediabase)/(?\'id\'\\d+[/_]\\w+)!";i:1;R:195;}}i:1;R:198;}s:11:"eighttracks";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:30:"!eighttracks://mix/(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!8tracks\\.com/[-\\w]+/\\D!";i:1;R:226;}}}}}s:4:"espn";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#";i:1;R:195;}}i:1;R:198;}s:8:"facebook";a:2:{i:0;a:7:{i:0;a:2:{i:0;s:148:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!marketplace/|pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";i:1;R:195;}i:1;a:2:{i:0;s:66:"@facebook\\.com/(?\'user\'[.\\w]+)/(?=(?:post|video)s?/)(?\'type\'[pv])@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:504;}i:4;a:2:{i:0;s:53:"@facebook.com/groups/[^/]*/(?\'type\'p)osts/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"type";i:2;s:2:"id";}}i:5;a:2:{i:0;s:56:"@facebook\\.com/(?\'user\'[.\\w]+)/posts/pfbid(?\'pfbid\'\\w+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:5:"pfbid";}}i:6;a:2:{i:0;s:95:"@facebook\\.com/permalink\\.php\\?story_fbid=(?:(?\'id\'\\d+)|pfbid(?\'pfbid\'\\w+))&id=(?\'page_id\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:5:"pfbid";i:3;s:7:"page_id";}}}i:1;a:3:{i:0;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:65:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'[pv])\\w+/(?\'id\'\\d+)(?!\\w)@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";i:3;s:2:"id";}}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:34:"@facebook\\.com/[.\\w]+/posts/pfbid@";i:1;R:226;}}s:3:"url";s:111:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2F{@user}%2Fposts%2Fpfbid{@pfbid}";}i:1;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:23:"@story_fbid=(?\'id\'\\d+)@";i:1;R:195;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:80:"@facebook\\.com/permalink\\.php\\?story_fbid=pfbid(?\'pfbid\'\\w+)&id=(?\'page_id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"pfbid";i:2;s:7:"page_id";}}}s:3:"url";s:140:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2Fpermalink.php%3Fstory_fbid%3Dpfbid{@pfbid}%26id%3D{@page_id}";}i:2;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:45:"@facebook\\.com/watch/\\?(?\'type\'v)=(?\'id\'\\d+)@";i:1;R:511;}i:1;a:2:{i:0;s:58:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'v)ideos/(?\'id\'\\d+)@";i:1;R:533;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"@fb\\.watch/.@";i:1;R:226;}}}}}s:7:"falstad";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:81:"!falstad\\.com/circuit/circuitjs\\.html\\?c(?:ct=(?\'cct\'[^&]+)|tz=(?\'ctz\'[-+=\\w]+))!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"cct";i:2;s:3:"ctz";}}}i:1;R:198;}s:6:"flickr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"@flickr\\.com/photos/[^/]+/(?\'id\'\\d+)@";i:1;R:195;}i:1;a:2:{i:0;s:33:"@flic\\.kr/(?!p/)[^/]+/(?\'id\'\\d+)@";i:1;R:195;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;R:576;}s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"@flic\\.kr/p/(?\'short\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:5:"short";}}}s:3:"url";s:52:"https://www.flickr.com/photo.gne?rb=1&short={@short}";}}}s:7:"foxnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:10:"funnyordie";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";i:1;R:195;}}i:1;R:198;}s:8:"gamespot";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";i:1;R:195;}}i:1;R:198;}s:5:"getty";a:2:{i:0;R:198;i:1;a:1:{i:0;a:3:{s:7:"extract";a:5:{i:0;a:2:{i:0;s:19:"!/embed/(?\'id\'\\d+)!";i:1;R:195;}i:1;a:2:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"height";}}i:2;a:2:{i:0;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"width";}}i:3;a:2:{i:0;s:21:"!\\?et=(?\'et\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"et";}}i:4;a:2:{i:0;s:28:"!\\\\u0026sig=(?\'sig\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"sig";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:59:"!(?:gty\\.im|gettyimages\\.[.\\w]+/detail(?=/).*?)/(?\'id\'\\d+)!";i:1;R:195;}}s:3:"url";s:43:"https://embed.gettyimages.com/preview/{@id}";}}}s:6:"gfycat";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?(?\'id\'\\w+)#";i:1;R:195;}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:17:"!/ifr/(?\'id\'\\w+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:87:"#gfycat\\.com/(?!gaming|reactions|stickers|gifs/tag)(?:gifs/detail/|ifr(?:ame)?/)?[a-z]#";i:1;R:226;}}s:3:"url";s:28:"https://gfycat.com/ifr/{@id}";}i:1;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:25:"!"height":(?\'height\'\\d+)!";i:1;R:610;}i:1;a:2:{i:0;s:23:"!"width":(?\'width\'\\d+)!";i:1;R:615;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:2:"//";i:1;R:226;}}s:3:"url";s:61:"https://api.gfycat.com/v1/oembed?url=https://gfycat.com/{@id}";}}}s:4:"gifs";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!";i:1;R:195;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:55:"!meta property="og:image:width" content="(?\'width\'\\d+)!";i:1;R:615;}i:1;a:2:{i:0;s:57:"!meta property="og:image:height" content="(?\'height\'\\d+)!";i:1;R:610;}}s:5:"match";R:651;s:3:"url";s:26:"https://gifs.com/gif/{@id}";}}}s:5:"giphy";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:62:"!giphy\\.com/(?\'type\'gif|video|webp)\\w+/(?:[-\\w]+-)*(?\'id\'\\w+)!";i:1;R:511;}i:1;a:2:{i:0;s:52:"!giphy\\.com/media/(?\'id\'\\w+)/\\w+\\.(?\'type\'gif|webp)!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"type";}}i:2;a:2:{i:0;s:45:"!i\\.giphy\\.com/(?\'id\'\\w+)\\.(?\'type\'gif|webp)!";i:1;R:673;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!"height"\\s*:\\s*(?\'height\'\\d+)!";i:1;R:610;}i:1;a:2:{i:0;s:29:"!"width"\\s*:\\s*(?\'width\'\\d+)!";i:1;R:615;}}s:5:"match";R:651;s:3:"url";s:83:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif";}}}s:4:"gist";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:75:"@gist\\.github\\.com/(?\'id\'(?:[-\\w]+/)?[\\da-f]+(?:/[\\da-f]+)?\\b(?!/archive))@";i:1;R:195;}}i:1;R:198;}s:10:"globalnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:692;s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"!globalnews\\.ca/video/rd/!";i:1;R:226;}}}}}s:8:"gofundme";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";i:1;R:195;}}i:1;R:198;}s:11:"googledrive";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:52:"!drive\\.google\\.com/.*?(?:file/d/|id=)(?\'id\'[-\\w]+)!";i:1;R:195;}}i:1;R:198;}s:10:"googleplus";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:83:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"name";i:2;s:3:"oid";i:3;s:3:"pid";}}}i:1;R:198;}s:12:"googlesheets";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:76:"@docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|(?:[^e]/)+)(?\'id\'(?:e/)?[-\\w]+)@";i:1;R:195;}i:1;a:2:{i:0;s:17:"@oid=(?\'oid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"oid";}}i:2;a:2:{i:0;s:18:"@#gid=(?\'gid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"gid";}}i:3;a:2:{i:0;s:20:"@/pub(?\'type\'chart)@";i:1;R:504;}}i:1;R:198;}s:4:"hudl";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"athlete";i:2;s:9:"highlight";}}i:1;a:2:{i:0;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:1;R:737;}i:2;a:2:{i:0;s:37:"@hudl\\.com/video/(?\'id\'\\w+)(?![\\w/])@";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;R:741;i:1;R:743;}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!hudl\\.com/v/!";i:1;R:226;}}}}}s:4:"hulu";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!eid=(?\'id\'[-\\w]+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:18:"!hulu\\.com/watch/!";i:1;R:226;}}}}}s:3:"ign";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:40:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!i";i:1;R:195;}}i:1;R:198;}s:4:"imdb";a:2:{i:0;R:198;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:45:"!imdb\\.com/[/\\w]+?/vi(?\'id\'\\d+)/[/\\w]*?embed!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:32:"!imdb\\.com/[/\\w]+?/vi(?\'id\'\\d+)!";i:1;R:195;}}s:3:"url";s:50:"https://www.imdb.com/video/imdb/vi{@id}/imdb/embed";}}}s:5:"imgur";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:25:"@imgur\\.com/(?\'id\'a/\\w+)@";i:1;R:195;}i:1;a:2:{i:0;s:38:"@i\\.imgur\\.com/(?\'id\'\\w{5,7})[lms]?\\.@";i:1;R:195;}i:2;a:2:{i:0;s:33:"@imgur\\.com/(?\'id\'\\w+)(?![\\w./])@";i:1;R:195;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"@data-id="(?\'id\'[\\w/]+)"@";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:63:"@imgur\\.com/(?![art]/|user/)(?\'path\'(?:gallery/)?\\w+)(?![\\w.])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"path";}}}s:3:"url";s:45:"https://api.imgur.com/oembed.xml?url=/{@path}";}}}s:9:"indiegogo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:1;R:195;}}i:1;R:198;}s:9:"instagram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!instagram\\.com/(?:p|reel|tv)/(?\'id\'[-\\w]+)!";i:1;R:195;}}i:1;R:198;}s:15:"internetarchive";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;R:195;}i:1;a:2:{i:0;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:1;R:615;}i:2;a:2:{i:0;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";i:1;R:610;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!archive\\.org/(?:details|embed)/!";i:1;R:226;}}}}}s:8:"izlesene";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:8:"jsfiddle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:96:"@jsfiddle.net/(?:(?\'user\'\\w+)/)?(?!\\d+\\b|embedded\\b|show\\b)(?\'id\'\\w+)\\b(?:/(?\'revision\'\\d+)\\b)?@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";i:3;s:8:"revision";}}}i:1;R:198;}s:10:"jwplatform";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!";i:1;R:195;}}i:1;R:198;}s:7:"kaltura";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:38:"@/p(?:artner_id)?/(?\'partner_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"partner_id";}}i:1;a:2:{i:0;s:17:"@/sp/(?\'sp\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:2:"sp";}}i:2;a:2:{i:0;s:31:"@/uiconf_id/(?\'uiconf_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:9:"uiconf_id";}}i:3;a:2:{i:0;s:32:"@\\bentry_id[=/](?\'entry_id\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:8:"entry_id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:113:"@kaltura\\.com/+p/(?\'partner_id\'\\d+)/sp/(?\'sp\'\\d+)/\\w*/uiconf_id/(?\'uiconf_id\'\\d+)/.*?\\bentry_id=(?\'entry_id\'\\w+)@";i:1;a:5:{i:0;s:0:"";i:1;s:10:"partner_id";i:2;s:2:"sp";i:3;s:9:"uiconf_id";i:4;s:8:"entry_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"@kaltura\\.com/(?:media/t|tiny)/.@";i:1;R:226;}}}}}s:3:"khl";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"!/feed/start/(?\'id\'[/\\w]+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";i:1;R:226;}}}}}s:11:"kickstarter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}}i:1;R:198;}s:6:"libsyn";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!embed/episode/id/(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:16:"@(?!\\.mp3)....$@";i:1;R:226;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:226;}}}}}s:10:"livestream";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:10:"account_id";i:2;s:8:"event_id";}}i:1;a:2:{i:0;s:26:"!/videos/(?\'video_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:2;a:2:{i:0;s:76:"!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;R:911;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@livestream\\.com/(?!accounts/\\d+/events/\\d)@";i:1;R:226;}}}i:1;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:70:"!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!";i:1;R:922;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!livestre.am!";i:1;R:226;}}}}}s:6:"mailru";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!"itemId": ?"?(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";i:1;R:226;}}}}}s:8:"mastodon";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"#//(?\'host\'[-.\\w]+)/@(?\'name\'\\w+)/(?\'id\'\\d+)#";i:1;a:4:{i:0;s:0:"";i:1;s:4:"host";i:2;s:4:"name";i:3;s:2:"id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:59:"#"url":"https://(?\'host\'[-.\\w]+)/@(?\'name\'\\w+)/(?\'id\'\\d+)"#";i:1;R:954;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:51:"#^(?\'origin\'https://[^/]+)/@\\w+@[-.\\w]+/(?\'id\'\\d+)#";i:1;a:3:{i:0;s:0:"";i:1;s:6:"origin";i:2;s:2:"id";}}}s:3:"url";s:31:"{@origin}/api/v1/statuses/{@id}";}}}s:6:"medium";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"#medium\\.com/(?:s/\\w+/|@?[-\\w]+/)?(?:\\w+-)*(?\'id\'[0-9a-f]+)(?!\\w)#";i:1;R:195;}}i:1;R:198;}s:9:"megaphone";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:46:"@megaphone\\.fm/.*?\\?(?:e|selected)=(?\'id\'\\w+)@";i:1;R:195;}i:1;a:2:{i:0;s:50:"@(?:dcs|player|traffic)\\.megaphone\\.fm/(?\'id\'\\w+)@";i:1;R:195;}i:2;a:2:{i:0;s:28:"@megaphone\\.link/(?\'id\'\\w+)@";i:1;R:195;}}i:1;R:198;}s:8:"metacafe";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:8:"mixcloud";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";i:1;R:195;}}i:1;R:198;}s:3:"mlb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"#mlb\\.com/video/(?:[-\\w/]+/)?(?:c-|v|[-\\w]+-c)(?\'id\'\\d+)#";i:1;R:195;}}i:1;R:198;}s:5:"mrctv";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!mrctv\\.org/embed/(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"!mrctv\\.org/videos/.!";i:1;R:226;}}}}}s:5:"msnbc";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:40:"@embedded-video/(?!undefined)(?\'id\'\\w+)@";i:1;R:195;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;R:226;}i:1;a:2:{i:0;s:18:"@on\\.msnbc\\.com/.@";i:1;R:226;}}}}}s:13:"natgeochannel";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";i:1;R:195;}}i:1;R:198;}s:11:"natgeovideo";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:22:"@guid="(?\'id\'[-\\w]+)"@";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";i:1;R:226;}}}}}s:7:"nbcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:9:"nbcsports";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!select/media/(?\'id\'\\w+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!nbcsports\\.com/video/.!";i:1;R:226;}}}}}s:3:"nhl";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:80:"#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:1:"t";i:2;s:1:"c";}}}i:1;R:198;}s:3:"npr";a:2:{i:0;R:198;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:1:"i";i:2;s:1:"m";}}}s:6:"header";s:45:"Cookie: trackingChoice=false; choiceVersion=1";s:5:"match";a:2:{i:0;a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;R:226;}i:1;a:2:{i:0;s:10:"!n\\.pr/\\w!";i:1;R:226;}}}}}s:7:"nytimes";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:1;R:195;}i:1;a:2:{i:0;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";i:1;R:195;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:26:"!/video/movies/(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:65:"!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"playlist";}}}s:3:"url";s:73:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true";}}}s:6:"odysee";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:58:"#odysee\\.com/(?:\\$/\\w+/)?(?\'name\'[^:/]+)[:/](?\'id\'\\w{40})#";i:1;a:3:{i:0;s:0:"";i:1;s:4:"name";i:2;s:2:"id";}}i:1;a:2:{i:0;s:43:"#odysee\\.com/(?\'path\'@[^:/]+:\\w/[^:/]+:\\w)#";i:1;R:790;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:64:"#"contentUrl".*api/\\w+/streams/\\w+/(?\'name\'[^/]+)/(?\'id\'\\w{40})#";i:1;R:1088;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"#odysee\\.com/@[^/:]+:\\w+/.#";i:1;R:226;}}}}}s:6:"orfium";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:24:"@album/(?\'album_id\'\\d+)@";i:1;R:294;}i:1;a:2:{i:0;s:30:"@playlist/(?\'playlist_id\'\\d+)@";i:1;R:305;}i:2;a:2:{i:0;s:25:"@live-set/(?\'set_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:6:"set_id";}}i:3;a:2:{i:0;s:24:"@track/(?\'track_id\'\\d+)@";i:1;R:279;}}i:1;R:198;}s:8:"pastebin";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@";i:1;R:195;}}i:1;R:198;}s:9:"pinterest";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:30:"@pinterest.com/pin/(?\'id\'\\d+)@";i:1;R:195;}i:1;a:2:{i:0;s:84:"@pinterest.com/(?!_/|discover/|explore/|news_hub/|pin/|search/)(?\'id\'[-\\w]+/[-\\w]+)@";i:1;R:195;}}i:1;R:198;}s:7:"podbean";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:65:"!podbean\\.com/(?:[-\\w]+/)*(?:player[-\\w]*/|\\w+/pb-)(?\'id\'[-\\w]+)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"!podbean\\.com/player[^/]*/\\?i=(?\'id\'[-\\w]+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"@podbean\\.com/(?:media/shar)?e/(?!pb-)@";i:1;R:226;}}}}}s:5:"prezi";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";i:1;R:195;}}i:1;R:198;}s:6:"reddit";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!(?\'id\'\\w+/comments/\\w+(?:/\\w+/\\w+)?)!";i:1;R:195;}}i:1;R:198;}s:6:"rumble";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!rumble\\.com/embed/(?\'id\'\\w+)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:21:"!video"?:"(?\'id\'\\w+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"#rumble\\.com/(?!embed/).#";i:1;R:226;}}}}}s:6:"rutube";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:58:"!rutube\\.ru/(?:play/embed/|tracks/.*?v=|video/)(?\'id\'\\w+)!";i:1;R:195;}}i:1;R:198;}s:6:"scribd";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:67:"!scribd\\.com/(?:mobile/)?(?:doc(?:ument)?|presentation)/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:7:"sendvid";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!sendvid\\.com/(?\'id\'\\w+)!";i:1;R:195;}}i:1;R:198;}s:10:"slideshare";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:54:"!slideshare.net/slideshow/embed_code/key/(?\'key\'\\w+)$!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"key";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:28:"!embed_code/key/(?\'key\'\\w+)!";i:1;R:1173;}i:1;a:2:{i:0;s:32:"!data-slideshow-id="(?\'id\'\\d+)"!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@slideshare\\.net/[^/]+/\\w(?![-\\w]+-\\d{6,}$)@";i:1;R:226;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:195;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;R:305;}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:93:"@soundcloud\\.com/(?!playlists/|tracks/)[-\\w]+/(?:sets/)?[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:43:"@soundcloud(?::/)?:tracks:(?\'track_id\'\\d+)@";i:1;R:279;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:226;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"@soundcloud(?::/)?/playlists:(?\'playlist_id\'\\d+)@";i:1;R:305;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:30:"@soundcloud\\.com/[-\\w]+/sets/@";i:1;R:226;}}}}}s:7:"sporcle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"#sporcle.com/framed/.*?gid=(?\'id\'\\w+)#";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"#encodedGameID\\W+(?\'id\'\\w+)#";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"#sporcle\\.com/games/(?!\\w*category/)[-\\w]+/[-\\w]#";i:1;R:226;}}}}}s:9:"sportsnet";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"@bc_videos\\s*:\\s*(?\'id\'\\d+)@";i:1;R:195;}}s:5:"match";R:651;}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:115:"!(?:open|play)\\.spotify\\.com/(?:user/[-.\\w]+/)?(?\'id\'(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:195;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1239;s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!link\\.tospotify\\.com/.!";i:1;R:226;}}}}}s:8:"spreaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!spreaker\\.com/episode/(?\'episode_id\'\\d+)!";i:1;R:220;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!episode_id=(?\'episode_id\'\\d+)!";i:1;R:220;}i:1;a:2:{i:0;s:25:"!show_id=(?\'show_id\'\\d+)!";i:1;R:215;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!(?\'url\'.+/(?:show/|user/.+/).+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"url";}}}s:3:"url";s:54:"https://api.spreaker.com/oembed?format=json&url={@url}";}}}s:10:"steamstore";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!store.steampowered.com/app/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:8:"stitcher";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:46:"!/(?:embed|splayer/f)/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"fid";i:2;s:3:"eid";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:32:"!/embed/(?\'fid\'\\d+)/(?\'eid\'\\d+)!";i:1;R:1274;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"!/(?:podcast/|show/|s\\?)!";i:1;R:226;}}}}}s:9:"strawpoll";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:10:"streamable";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!streamable\\.com/(?:e/)?(?\'id\'\\w+)!";i:1;R:195;}}i:1;R:198;}s:8:"streamja";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@streamja\\.com/(?!login|signup|terms|videos)(?\'id\'\\w+)@";i:1;R:195;}}i:1;R:198;}s:8:"teamcoco";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:20:"!embed/v/(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!teamcoco\\.com/video/\\D!";i:1;R:226;}}}}}s:3:"ted";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i";i:1;R:195;}}i:1;R:198;}s:8:"telegram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:56:"@//t.me/(?!addstickers/|joinchat/)(?:s/)?(?\'id\'\\w+/\\d+)@";i:1;R:195;}}i:1;R:198;}s:11:"theatlantic";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:11:"theguardian";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!theguardian\\.com/(?\'id\'\\w+/video/20(?:0[0-9]|1[0-7])[-/\\w]+)!";i:1;R:195;}}i:1;R:198;}s:8:"theonion";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:6:"tiktok";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"#tiktok\\.com/(?:@[.\\w]+/video|v|(?:i18n/)?share/video)/(?\'id\'\\d+)#";i:1;R:195;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:67:"#tiktok\\.com/(?:@[.\\w]+/video|v|(?:i18n/)?/share/video)/(?\'id\'\\d+)#";i:1;R:195;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:39:"#//v[mt]\\.tiktok\\.com/(?\'short_id\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"short_id";}}i:1;a:2:{i:0;s:32:"#tiktok\\.com/t/(?\'short_id\'\\w+)#";i:1;R:1342;}}s:3:"url";s:36:"https://www.tiktok.com/t/{@short_id}";}}}s:3:"tmz";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";i:1;R:195;}}i:1;R:198;}s:11:"tradingview";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!tradingview\\.com/(?:chart/[^/]+|i)/(?\'chart\'\\w+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"chart";}}i:1;a:2:{i:0;s:45:"!tradingview\\.com/symbols/(?\'symbol\'[-:\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"symbol";}}}i:1;R:198;}s:13:"traileraddict";a:2:{i:0;R:198;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";i:1;R:226;}}}}}s:13:"trendingviews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:89:"!(?:mydailyfreedom\\.com|trendingviews\\.co)/(?:tv/)?(?:embed|video)/(?:[^/]+-)?(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:6:"tumblr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";i:1;R:1088;}i:1;a:2:{i:0;s:52:"!(?:at|www)\\.tumblr\\.com/(?\'name\'[-\\w]+)/(?\'id\'\\d+)!";i:1;R:1088;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:35:"!did=(?:\\\\"|\\\\u0022)(?\'did\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"did";}}i:1;a:2:{i:0;s:29:"!embed/post/t:(?\'key\'[-\\w]+)!";i:1;R:1173;}}s:6:"header";s:16:"User-agent: curl";s:5:"match";a:2:{i:0;a:2:{i:0;s:25:"!\\w\\.tumblr\\.com/post/\\d!";i:1;R:226;}i:1;a:2:{i:0;s:36:"!(?:at|www)\\.tumblr\\.com/[-\\w]+/\\d+!";i:1;R:226;}}s:3:"url";s:75:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}";}}}s:21:"twentyfoursevensports";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!247sports\\.com/PlayerSport/[-\\w]*?(?\'player_id\'\\d+)/Embed!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"player_id";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";R:1401;s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!247sports\\.com/Player/[-\\w]*?\\d!";i:1;R:226;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:38:"!embedVideoContainer_(?\'video_id\'\\d+)!";i:1;R:917;}}s:6:"header";s:116:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!247sports\\.com/Video/.!";i:1;R:226;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;R:917;}i:1;a:2:{i:0;s:73:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)(?:/clip/(?\'clip_id\'[-\\w]+))?#";i:1;R:922;}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:457;}i:3;a:2:{i:0;s:59:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'[-\\w]+)#";i:1;R:922;}}i:1;R:198;}s:7:"twitter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@twitter\\.com/(?:#!/|i/)?\\w+/(?:status(?:es)?|tweet)/(?\'id\'\\d+)@";i:1;R:195;}}i:1;R:198;}s:7:"ustream";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"vid";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!embed/(?\'cid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"cid";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";i:1;R:226;}}}}}s:5:"vbox7";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";i:1;R:195;}}i:1;R:198;}s:4:"veoh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!";i:1;R:195;}}i:1;R:198;}s:4:"vevo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!vevo\\.com/watch/(.*?/)?(?\'id\'[A-Z]+\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:0:"";i:2;s:2:"id";}}}i:1;R:198;}s:14:"videodetective";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!";i:1;R:195;}}i:1;R:198;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:67:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)(?:/(?\'h\'\\w+))?\\b!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:1:"h";}}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:457;}}i:1;R:198;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:195;}}i:1;R:198;}s:2:"vk";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:97:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";i:3;s:4:"hash";}}i:1;a:2:{i:0;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";i:1;R:1491;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:99:"#meta property="og:video" content=".*?oid=(?\'oid\'-?\\d+).*?id=(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)#";i:1;R:1491;}}s:6:"header";s:80:"User-agent: Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0";s:5:"match";a:1:{i:0;a:2:{i:0;s:15:"#^(?!.*?hash=)#";i:1;R:226;}}}}}s:7:"vocaroo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!voca(?:\\.ro|roo\\.com)/(?:i/)?(?\'id\'\\w+)!";i:1;R:195;}}i:1;R:198;}s:3:"vox";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";i:1;R:195;}}i:1;R:198;}s:14:"washingtonpost";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:51:"#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#";i:1;R:195;}i:1;a:2:{i:0;s:65:"#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#";i:1;R:195;}}i:1;R:198;}s:7:"wavekit";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:59:"#play\\.wavekit\\.app/(?:embed|share)/audio/(?\'audio_id\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"audio_id";}}i:1;a:2:{i:0;s:65:"#play\\.wavekit\\.app/(?:embed|share)/playlist/(?\'playlist_id\'\\w+)#";i:1;R:305;}}i:1;R:198;}s:6:"wistia";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)(?\'id\'\\w+)!";i:1;R:195;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:33:"!"type":"(?:\\w+_)?(?\'type\'audio)!";i:1;R:504;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:55:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)\\w!";i:1;R:226;}}s:3:"url";s:42:"https://fast.wistia.net/embed/iframe/{@id}";}}}s:4:"wshh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!worldstar(?:hiphop)?\\.com/(?:emb|featur)ed/(?\'id\'\\d+)!";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:55:"!(?:v: ?"?|worldstar(?:hiphop)?\\.com/embed/)(?\'id\'\\d+)!";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:54:"!worldstar(?:hiphop)?\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;R:226;}}}}}s:3:"wsj";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:1;R:195;}i:1;a:2:{i:0;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";i:1;R:195;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"@guid=(?\'id\'[-0-9A-F]{36})@";i:1;R:195;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:17:"@on\\.wsj\\.com/\\w@";i:1;R:226;}}}}}s:9:"xboxclips";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"@(?:gameclips\\.io|xboxclips\\.com)/(?!game/)(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@";i:1;R:432;}}i:1;R:198;}s:7:"xboxdvr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!(?:gamer|xbox)dvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";i:1;R:432;}}i:1;R:198;}s:5:"youku";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!youku\\.com/v(?:_show|ideo)/id_(?\'id\'\\w+=*)!";i:1;R:195;}}i:1;R:198;}s:8:"youmaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!youmaker\\.com/(?:embed|v(?:ideo)?)/(?\'id\'[-a-z0-9]+)!i";i:1;R:195;}}i:1;R:198;}s:7:"youtube";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:91:"!youtube\\.com/(?:watch.*?v=|(?:embed|live|shorts|v)/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:195;}i:1;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:195;}i:2;a:2:{i:0;s:25:"@[#&?]t=(?\'t\'\\d[\\dhms]*)@";i:1;R:457;}i:3;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;R:198;}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:1:{i:0;i:771;}s:5:"flags";i:0;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:135:{s:7:"ABCNEWS";a:7:{s:10:"attributes";a:1:{s:2:"id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:198;}}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:1:{i:0;i:256;}}s:5:"ACAST";a:7:{s:10:"attributes";a:3:{s:10:"episode_id";R:1605;s:7:"show_id";R:1605;s:1:"t";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"AMAZON";a:7:{s:10:"attributes";a:2:{s:2:"id";a:2:{s:8:"required";b:1;s:11:"filterChain";R:198;}s:3:"tld";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"ANCHOR";R:1603;s:13:"APPLEPODCASTS";a:7:{s:10:"attributes";a:3:{s:7:"country";R:1605;s:10:"episode_id";R:1605;s:10:"podcast_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:9:"AUDIOBOOM";R:1603;s:9:"AUDIOMACK";a:7:{s:10:"attributes";a:3:{s:6:"artist";R:1605;s:4:"mode";R:1605;s:5:"title";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"AUDIUS";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1605;s:11:"playlist_id";R:1605;s:8:"track_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1605;s:8:"track_id";R:1605;s:9:"track_num";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:7:"BBCNEWS";R:1603;s:8:"BITCHUTE";R:1603;s:14:"BLEACHERREPORT";R:1603;s:10:"BRIGHTCOVE";a:7:{s:10:"attributes";a:3:{s:5:"bckey";R:1605;s:5:"bcpid";R:1605;s:5:"bctid";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:5:"BUNNY";a:7:{s:10:"attributes";a:2:{s:8:"video_id";R:1605;s:16:"video_library_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"CASTOS";a:7:{s:10:"attributes";a:2:{s:4:"host";R:1605;s:2:"id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:7:"CBSNEWS";R:1603;s:4:"CLYP";R:1603;s:4:"CNBC";R:1603;s:3:"CNN";R:1603;s:8:"CNNMONEY";R:1603;s:7:"CODEPEN";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1605;s:4:"user";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:13:"COMEDYCENTRAL";R:1603;s:4:"COUB";R:1603;s:11:"DAILYMOTION";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1605;s:1:"t";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:12:"DEMOCRACYNOW";R:1603;s:7:"DUMPERT";R:1603;s:11:"EIGHTTRACKS";R:1603;s:4:"ESPN";R:1603;s:8:"FACEBOOK";a:7:{s:10:"attributes";a:5:{s:2:"id";R:1605;s:7:"page_id";R:1605;s:5:"pfbid";R:1605;s:4:"type";R:1605;s:4:"user";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:7:"FALSTAD";a:7:{s:10:"attributes";a:2:{s:3:"cct";R:1605;s:3:"ctz";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"FLICKR";R:1603;s:7:"FOXNEWS";R:1603;s:10:"FUNNYORDIE";R:1603;s:8:"GAMESPOT";R:1603;s:5:"GETTY";a:7:{s:10:"attributes";a:5:{s:2:"et";R:1629;s:6:"height";a:3:{s:12:"defaultValue";i:360;s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:0;}s:2:"id";R:1605;s:3:"sig";R:1629;s:5:"width";a:3:{s:12:"defaultValue";i:640;s:11:"filterChain";R:1693;s:8:"required";b:0;}}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"GFYCAT";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1691;s:2:"id";R:1605;s:5:"width";R:1699;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:4:"GIFS";R:1705;s:5:"GIPHY";a:7:{s:10:"attributes";a:4:{s:6:"height";R:1691;s:2:"id";R:1605;s:4:"type";R:1605;s:5:"width";R:1699;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:4:"GIST";R:1603;s:10:"GLOBALNEWS";R:1603;s:8:"GOFUNDME";R:1603;s:11:"GOOGLEDRIVE";R:1603;s:10:"GOOGLEPLUS";a:7:{s:10:"attributes";a:3:{s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:9:"urldecode";s:6:"params";R:1696;}}s:8:"required";b:0;}s:3:"oid";R:1605;s:3:"pid";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:12:"GOOGLESHEETS";a:7:{s:10:"attributes";a:4:{s:3:"gid";R:1605;s:2:"id";R:1605;s:3:"oid";R:1605;s:4:"type";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:4:"HUDL";a:7:{s:10:"attributes";a:3:{s:7:"athlete";R:1605;s:9:"highlight";R:1605;s:2:"id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:4:"HULU";R:1603;s:3:"IGN";R:1603;s:4:"IMDB";R:1603;s:5:"IMGUR";R:1603;s:9:"INDIEGOGO";R:1603;s:9:"INSTAGRAM";R:1603;s:15:"INTERNETARCHIVE";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1691;s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:23:"htmlspecialchars_decode";s:6:"params";R:1696;}}s:8:"required";b:0;}s:5:"width";R:1699;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:8:"IZLESENE";R:1603;s:8:"JSFIDDLE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1605;s:8:"revision";R:1605;s:4:"user";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:10:"JWPLATFORM";R:1603;s:7:"KALTURA";a:7:{s:10:"attributes";a:4:{s:8:"entry_id";R:1629;s:10:"partner_id";R:1629;s:2:"sp";R:1605;s:9:"uiconf_id";R:1629;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:3:"KHL";R:1603;s:11:"KICKSTARTER";a:7:{s:10:"attributes";a:3:{s:4:"card";R:1605;s:2:"id";R:1605;s:5:"video";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"LIBSYN";R:1603;s:8:"LIVELEAK";R:1603;s:10:"LIVESTREAM";a:7:{s:10:"attributes";a:5:{s:10:"account_id";R:1605;s:7:"channel";R:1605;s:7:"clip_id";R:1605;s:8:"event_id";R:1605;s:8:"video_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"MAILRU";R:1603;s:8:"MASTODON";a:7:{s:10:"attributes";a:3:{s:4:"host";R:1629;s:2:"id";R:1605;s:4:"name";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:198;s:9:"bitNumber";i:0;s:7:"allowed";a:1:{i:0;i:770;}}s:6:"MEDIUM";R:1603;s:9:"MEGAPHONE";R:1603;s:8:"METACAFE";R:1603;s:8:"MIXCLOUD";R:1603;s:3:"MLB";R:1603;s:5:"MRCTV";R:1603;s:5:"MSNBC";R:1603;s:13:"NATGEOCHANNEL";R:1603;s:11:"NATGEOVIDEO";R:1603;s:7:"NBCNEWS";R:1603;s:9:"NBCSPORTS";R:1603;s:3:"NHL";a:7:{s:10:"attributes";a:2:{s:1:"c";R:1605;s:1:"t";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:3:"NPR";a:7:{s:10:"attributes";a:2:{s:1:"i";R:1605;s:1:"m";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:7:"NYTIMES";R:1603;s:6:"ODYSEE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1605;s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:0;}s:4:"path";R:1799;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"ORFIUM";a:7:{s:10:"attributes";a:4:{s:8:"album_id";R:1605;s:11:"playlist_id";R:1605;s:6:"set_id";R:1605;s:8:"track_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:8:"PASTEBIN";R:1603;s:9:"PINTEREST";R:1603;s:7:"PODBEAN";R:1603;s:5:"PREZI";R:1603;s:6:"REDDIT";R:1603;s:6:"RUMBLE";R:1603;s:6:"RUTUBE";R:1603;s:6:"SCRIBD";R:1603;s:7:"SENDVID";R:1603;s:10:"SLIDESHARE";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1605;s:3:"key";R:1629;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:1605;s:11:"playlist_id";R:1605;s:12:"secret_token";R:1605;s:8:"track_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:7:"SPORCLE";R:1603;s:9:"SPORTSNET";R:1603;s:7:"SPOTIFY";R:1603;s:8:"SPREAKER";a:7:{s:10:"attributes";a:2:{s:10:"episode_id";R:1605;s:7:"show_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:10:"STEAMSTORE";R:1603;s:8:"STITCHER";a:7:{s:10:"attributes";a:2:{s:3:"eid";R:1605;s:3:"fid";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:9:"STRAWPOLL";R:1603;s:10:"STREAMABLE";R:1603;s:8:"STREAMJA";R:1603;s:8:"TEAMCOCO";R:1603;s:3:"TED";R:1603;s:8:"TELEGRAM";R:1603;s:11:"THEATLANTIC";R:1603;s:11:"THEGUARDIAN";R:1603;s:8:"THEONION";R:1603;s:6:"TIKTOK";R:1603;s:3:"TMZ";R:1603;s:11:"TRADINGVIEW";a:7:{s:10:"attributes";a:2:{s:5:"chart";R:1605;s:6:"symbol";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:13:"TRAILERADDICT";R:1603;s:13:"TRENDINGVIEWS";R:1603;s:6:"TUMBLR";a:7:{s:10:"attributes";a:4:{s:3:"did";R:1629;s:2:"id";R:1605;s:3:"key";R:1629;s:4:"name";R:1629;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:21:"TWENTYFOURSEVENSPORTS";a:7:{s:10:"attributes";a:2:{s:9:"player_id";R:1605;s:8:"video_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:1605;s:7:"clip_id";R:1605;s:1:"t";R:1605;s:8:"video_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:7:"TWITTER";R:1603;s:7:"USTREAM";a:7:{s:10:"attributes";a:2:{s:3:"cid";R:1605;s:3:"vid";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:5:"VBOX7";R:1603;s:4:"VEOH";R:1603;s:4:"VEVO";R:1603;s:14:"VIDEODETECTIVE";R:1603;s:5:"VIMEO";a:7:{s:10:"attributes";a:3:{s:1:"h";R:1605;s:2:"id";R:1605;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:1696;}}s:8:"required";b:0;}}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:4:"VINE";R:1603;s:2:"VK";a:7:{s:10:"attributes";a:3:{s:4:"hash";R:1605;s:3:"oid";R:1605;s:3:"vid";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:7:"VOCAROO";R:1603;s:3:"VOX";R:1603;s:14:"WASHINGTONPOST";R:1603;s:7:"WAVEKIT";a:7:{s:10:"attributes";a:2:{s:8:"audio_id";R:1605;s:11:"playlist_id";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:6:"WISTIA";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1605;s:4:"type";R:1605;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}s:4:"WSHH";R:1603;s:3:"WSJ";R:1603;s:9:"XBOXCLIPS";R:1669;s:7:"XBOXDVR";R:1669;s:5:"YOUKU";R:1603;s:8:"YOUMAKER";R:1603;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:3:{s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}s:4:"list";R:1605;s:1:"t";R:1863;}s:11:"filterChain";R:1607;s:12:"nestingLimit";i:10;s:5:"rules";R:1616;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1620;}}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer()
	{
		return unserialize('O:44:"s9e\\TextFormatter\\Bundles\\MediaPack\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:10:{s:20:"AMAZON_ASSOCIATE_TAG";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_CA";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_DE";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_ES";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_FR";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IN";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_IT";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_JP";s:0:"";s:23:"AMAZON_ASSOCIATE_TAG_UK";s:0:"";s:16:"MEDIAEMBED_THEME";s:0:"";}}');
	}
}