<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('en', array (
  'messages+intl-icu' => 
  array (
    'core.admin.appearance.colored_header_label' => 'Colored Header',
    'core.admin.appearance.colors_heading' => 'Colors',
    'core.admin.appearance.colors_primary_label' => 'Primary Color',
    'core.admin.appearance.colors_secondary_label' => 'Secondary Color',
    'core.admin.appearance.colors_text' => 'Choose two colors to theme your forum with. The first will be used as a highlight color, while the second will be used to style background elements.',
    'core.admin.appearance.custom_footer_heading' => 'Custom Footer',
    'core.admin.appearance.custom_footer_text' => '=> core.ref.custom_footer_text',
    'core.admin.appearance.custom_header_heading' => 'Custom Header',
    'core.admin.appearance.custom_header_text' => '=> core.ref.custom_header_text',
    'core.admin.appearance.custom_styles_cannot_use_less_features' => 'The @import and data-uri features are not allowed in custom LESS.',
    'core.admin.appearance.custom_styles_heading' => 'Custom Styles',
    'core.admin.appearance.custom_styles_text' => 'Customize your forum\'s appearance by adding your own Less/CSS code to be applied on top of Flarum\'s default styles.',
    'core.admin.appearance.dark_mode_label' => 'Dark Mode',
    'core.admin.appearance.description' => 'Customize your forum\'s colors, logos, and other variables.',
    'core.admin.appearance.edit_css_button' => 'Edit Custom CSS',
    'core.admin.appearance.edit_footer_button' => '=> core.ref.custom_footer_title',
    'core.admin.appearance.edit_header_button' => '=> core.ref.custom_header_title',
    'core.admin.appearance.enter_hex_message' => 'Please enter a hexadecimal color code.',
    'core.admin.appearance.favicon_heading' => 'Favicon',
    'core.admin.appearance.favicon_text' => 'Upload an image to be displayed as the forum\'s shortcut icon.',
    'core.admin.appearance.logo_heading' => 'Logo',
    'core.admin.appearance.logo_text' => 'Upload an image to be displayed in place of the forum title.',
    'core.admin.appearance.title' => 'Appearance',
    'core.admin.basics.default_language_heading' => 'Default Language',
    'core.admin.basics.description' => 'Set your forum title, language, and other basic settings.',
    'core.admin.basics.display_name_heading' => 'User Display Name',
    'core.admin.basics.display_name_text' => 'Select the driver that should be used for users\' display names. By default, the username is shown.',
    'core.admin.basics.forum_description_heading' => 'Forum Description',
    'core.admin.basics.forum_description_text' => 'Enter a short sentence or two that describes your community. This will appear in the meta tag and show up in search engines.',
    'core.admin.basics.forum_title_heading' => 'Forum Title',
    'core.admin.basics.home_page_heading' => 'Home Page',
    'core.admin.basics.home_page_text' => 'Choose the page which users will first see when they visit your forum.',
    'core.admin.basics.show_language_selector_label' => 'Show language selector',
    'core.admin.basics.slug_driver_heading' => 'Slug Driver: {model}',
    'core.admin.basics.slug_driver_text' => 'Select a driver to be used for slugging this model.',
    'core.admin.basics.title' => 'Basics',
    'core.admin.basics.welcome_banner_heading' => 'Welcome Banner',
    'core.admin.create_user.email_placeholder' => '=> core.ref.email',
    'core.admin.create_user.email_confirmed_label' => 'Require user to confirm this email',
    'core.admin.create_user.submit_and_create_another_button' => 'Create and add another',
    'core.admin.create_user.submit_button' => 'Create user',
    'core.admin.create_user.title' => 'Create new user',
    'core.admin.dashboard.clear_cache_button' => 'Clear Cache',
    'core.admin.dashboard.description' => 'Your forum at a glance.',
    'core.admin.dashboard.io_error_message' => 'Could not write to filesystem. Check your filesystem permissions and try again. Or try running from the command line.',
    'core.admin.dashboard.status.headers.scheduler-status' => 'Scheduler',
    'core.admin.dashboard.status.headers.queue-driver' => 'Queue Driver',
    'core.admin.dashboard.status.headers.session-driver' => 'Session Driver',
    'core.admin.dashboard.status.scheduler.active' => 'Active',
    'core.admin.dashboard.status.scheduler.inactive' => 'Inactive',
    'core.admin.dashboard.status.scheduler.never-run' => 'Never run',
    'core.admin.dashboard.title' => 'Dashboard',
    'core.admin.dashboard.tools_button' => 'Tools',
    'core.admin.debug-warning.detail' => 'When <code>debug</code> mode is active, Flarum will rebuild its <code>JavaScript</code> and <code>CSS</code> assets on every request, and could also potentially leak other information, such as database secrets, environment variables, etc.

It is highly recommended to disable <code>debug</code> in your <code>config.php</code> file in production. See <link>Flarum docs</link> for more information.
',
    'core.admin.debug-warning.label' => 'Debug mode active',
    'core.admin.edit_css.customize_text' => 'Customize your forum\'s appearance by adding your own Less/CSS code to be applied on top of Flarum\'s <a>default styles</a>.',
    'core.admin.edit_css.title' => 'Edit Custom CSS',
    'core.admin.edit_footer.customize_text' => '=> core.ref.custom_footer_text',
    'core.admin.edit_footer.title' => '=> core.ref.custom_footer_title',
    'core.admin.edit_group.delete_confirmation' => 'Are you sure you want to delete this group? The group members will NOT be deleted.',
    'core.admin.edit_group.hide_label' => 'Hide on forum',
    'core.admin.edit_group.icon_label' => '=> core.ref.icon',
    'core.admin.edit_group.icon_text' => '=> core.ref.icon_text',
    'core.admin.edit_group.plural_placeholder' => 'Plural (e.g. Mods)',
    'core.admin.edit_group.singular_placeholder' => 'Singular (e.g. Mod)',
    'core.admin.edit_header.customize_text' => '=> core.ref.custom_header_text',
    'core.admin.edit_header.submit_button' => '=> core.ref.save_changes',
    'core.admin.edit_header.title' => '=> core.ref.custom_header_title',
    'core.admin.email.addresses_heading' => 'Addresses',
    'core.admin.email.description' => 'Configure the driver, settings and addresses your forum will use to send email.',
    'core.admin.email.driver_heading' => 'Choose a Driver',
    'core.admin.email.driver_label' => 'Driver',
    'core.admin.email.from_label' => 'Sender',
    'core.admin.email.mail_encryption_label' => 'Encryption',
    'core.admin.email.mail_host_label' => 'Host',
    'core.admin.email.mail_mailgun_domain_label' => 'Domain',
    'core.admin.email.mail_mailgun_region_label' => 'Region',
    'core.admin.email.mail_mailgun_secret_label' => 'Secret key',
    'core.admin.email.mail_port_label' => 'Port',
    'core.admin.email.mailgun_heading' => 'Mailgun Settings',
    'core.admin.email.not_sending_message' => 'Flarum currently does not send emails. This can be due to the selected driver, or errors in its configuration.',
    'core.admin.email.send_test_mail_button' => 'Send',
    'core.admin.email.send_test_mail_heading' => 'Send Test Mail',
    'core.admin.email.send_test_mail_success' => 'Test mail sent successfully!',
    'core.admin.email.send_test_mail_text' => 'This will send an email using the above configuration to your email, {email}.',
    'core.admin.email.smtp_heading' => 'SMTP Settings',
    'core.admin.email.title' => '=> core.ref.email',
    'core.admin.extension.configure_scopes' => 'Configure Scopes',
    'core.admin.extension.confirm_purge' => 'Purging will remove all database entries and assets related to the extension. It will not uninstall the extension; that must be done via Composer. Are you sure you want to continue?',
    'core.admin.extension.disabled' => 'Disabled',
    'core.admin.extension.enable_to_see' => 'Enable the extension to view and change settings.',
    'core.admin.extension.enabled' => 'Enabled',
    'core.admin.extension.info_links.discuss' => 'Discuss',
    'core.admin.extension.info_links.documentation' => 'Documentation',
    'core.admin.extension.info_links.donate' => 'Donate',
    'core.admin.extension.info_links.source' => 'Source',
    'core.admin.extension.info_links.support' => 'Support',
    'core.admin.extension.info_links.website' => 'Website',
    'core.admin.extension.no_permissions' => 'This extension has no permissions.',
    'core.admin.extension.no_settings' => 'This extension has no settings.',
    'core.admin.extension.open_modal' => 'Open Settings',
    'core.admin.extension.permissions_title' => 'Permissions',
    'core.admin.extension.purge_button' => 'Purge',
    'core.admin.extension.readme.button_label' => 'README',
    'core.admin.extension.readme.no_readme' => 'This extension does not appear to have a README file',
    'core.admin.extension.readme.title' => '{extName} documentation',
    'core.admin.header.get_help' => 'Get Help',
    'core.admin.loading.title' => 'Please Wait...',
    'core.admin.nav.appearance_button' => '=> core.admin.appearance.title',
    'core.admin.nav.appearance_title' => '=> core.admin.appearance.description',
    'core.admin.nav.basics_button' => '=> core.admin.basics.title',
    'core.admin.nav.basics_title' => '=> core.admin.basics.description',
    'core.admin.nav.categories.authentication' => 'Authentication',
    'core.admin.nav.categories.core' => 'Core Configuration',
    'core.admin.nav.categories.feature' => 'Features',
    'core.admin.nav.categories.formatting' => 'Formatting',
    'core.admin.nav.categories.language' => 'Languages',
    'core.admin.nav.categories.moderation' => 'Moderation',
    'core.admin.nav.categories.other' => 'Other Extensions',
    'core.admin.nav.categories.theme' => 'Themes',
    'core.admin.nav.dashboard_button' => '=> core.admin.dashboard.title',
    'core.admin.nav.dashboard_title' => '=> core.admin.dashboard.description',
    'core.admin.nav.email_button' => '=> core.ref.email',
    'core.admin.nav.email_title' => '=> core.admin.email.description',
    'core.admin.nav.permissions_button' => '=> core.admin.permissions.title',
    'core.admin.nav.permissions_title' => '=> core.admin.permissions.description',
    'core.admin.nav.userlist_button' => '=> core.admin.users.title',
    'core.admin.nav.userlist_title' => '=> core.admin.users.description',
    'core.admin.nav.search_placeholder' => 'Search Extensions',
    'core.admin.permissions.allow_renaming_label' => 'Allow renaming',
    'core.admin.permissions.create_access_token_label' => 'Create access token',
    'core.admin.permissions.create_heading' => 'Create',
    'core.admin.permissions.description' => 'Configure who can see and do what.',
    'core.admin.permissions.edit_users_label' => 'Edit user attributes',
    'core.admin.permissions.edit_users_credentials_label' => 'Edit user credentials',
    'core.admin.permissions.edit_users_groups_label' => 'Edit user groups',
    'core.admin.permissions.global_heading' => 'Global',
    'core.admin.permissions.moderate_heading' => 'Moderate',
    'core.admin.permissions.moderate_access_tokens_label' => 'Moderate Access Tokens',
    'core.admin.permissions.new_group_button' => 'New Group',
    'core.admin.permissions.participate_heading' => 'Participate',
    'core.admin.permissions.read_heading' => 'Read',
    'core.admin.permissions.search_users_label' => '=> core.ref.search_users',
    'core.admin.permissions.title' => 'Permissions',
    'core.admin.permissions.view_hidden_groups_label' => 'View hidden group badges',
    'core.admin.permissions.view_last_seen_at_label' => 'Always view user last seen time',
    'core.admin.permissions_controls.allow_indefinitely_button' => 'Indefinitely',
    'core.admin.permissions_controls.allow_never_button' => '=> core.ref.never',
    'core.admin.permissions_controls.allow_some_minutes_button' => '{count, plural, one {For # minute} other {For # minutes}}',
    'core.admin.permissions_controls.allow_ten_minutes_button' => 'For 10 minutes',
    'core.admin.permissions_controls.everyone_button' => 'Everyone',
    'core.admin.permissions_controls.members_button' => '=> core.group.members',
    'core.admin.permissions_controls.signup_closed_button' => 'Closed',
    'core.admin.permissions_controls.signup_open_button' => 'Open',
    'core.admin.settings.saved_message' => 'Your changes were saved.',
    'core.admin.settings.submit_button' => '=> core.ref.save_changes',
    'core.admin.upload_image.remove_button' => '=> core.ref.remove',
    'core.admin.upload_image.upload_button' => 'Choose an Image...',
    'core.admin.users.create_user_button' => 'New User',
    'core.admin.users.description' => 'A paginated list of all users on your forum.',
    'core.admin.users.grid.columns.display_name.title' => 'Display name',
    'core.admin.users.grid.columns.email.title' => '=> core.ref.email',
    'core.admin.users.grid.columns.email.visibility_hide' => 'Hide email address',
    'core.admin.users.grid.columns.email.visibility_show' => 'Show email address',
    'core.admin.users.grid.columns.group_badges.no_badges' => 'None',
    'core.admin.users.grid.columns.group_badges.title' => 'Groups',
    'core.admin.users.grid.columns.user_id.title' => 'ID',
    'core.admin.users.grid.invalid_column_content' => 'Invalid',
    'core.admin.users.pagination.back_button' => 'Previous page',
    'core.admin.users.pagination.first_button' => 'Go to first page',
    'core.admin.users.pagination.go_to_page_textbox_a11y_label' => 'Go directly to page number',
    'core.admin.users.pagination.last_button' => 'Go to last page',
    'core.admin.users.pagination.next_button' => 'Next page',
    'core.admin.users.pagination.page_counter' => 'Page {current} of {total}',
    'core.admin.users.search_placeholder' => '=> core.ref.search_users',
    'core.admin.users.title' => '=> core.ref.users',
    'core.admin.users.total_users' => 'Total users: {count}',
    'core.forum.change_email.dismiss_button' => '=> core.ref.okay',
    'core.forum.change_email.submit_button' => '=> core.ref.save_changes',
    'core.forum.change_email.title' => '=> core.ref.change_email',
    'core.forum.composer.close_tooltip' => 'Close',
    'core.forum.composer.exit_full_screen_tooltip' => 'Exit Full Screen',
    'core.forum.composer.full_screen_tooltip' => 'Full Screen',
    'core.forum.composer.minimize_tooltip' => 'Minimize',
    'core.forum.composer_edit.discard_confirmation' => 'You have not saved your changes. Do you wish to discard them?',
    'core.forum.composer_edit.edited_message' => 'Your edit was made.',
    'core.forum.discussion_list.total_replies_a11y_label' => '{count, plural, one {# reply} other {# replies}}',
    'core.forum.discussion_list.unread_replies_a11y_label' => '{count, plural, one {# unread reply} other {# unread replies}}. Mark unread {count, plural, one {reply} other {replies}} as read.',
    'core.forum.forgot_password.dismiss_button' => '=> core.ref.okay',
    'core.forum.forgot_password.email_placeholder' => '=> core.ref.email',
    'core.forum.header.locale_dropdown_accessible_label' => 'Change forum locale',
    'core.forum.header.search_clear_button_accessible_label' => 'Clear search query',
    'core.forum.header.session_dropdown_accessible_label' => 'Toggle session options dropdown menu',
    'core.forum.index.refresh_tooltip' => 'Refresh',
    'core.forum.index.toggle_sidenav_dropdown_accessible_label' => 'Toggle navigation dropdown menu',
    'core.forum.index_sort.relevance_button' => 'Relevance',
    'core.forum.log_in.invalid_login_message' => 'Your login details were incorrect.',
    'core.forum.post_controls.toggle_dropdown_accessible_label' => 'Toggle post controls dropdown menu',
    'core.forum.post_scrubber.viewing_text' => '{count, plural, one {{index} of {formattedCount} post} other {{index} of {formattedCount} posts}}',
    'core.forum.search.users_heading' => '=> core.ref.users',
    'core.forum.security.browser_on_operating_system' => '{browser} on {os}',
    'core.forum.security.cannot_terminate_current_session' => 'Cannot terminate the current active session. Log out instead.',
    'core.forum.security.created' => 'Created',
    'core.forum.security.current_active_session' => 'Current Active Session',
    'core.forum.security.developer_tokens_heading' => 'Developer Tokens',
    'core.forum.security.global_logout.heading' => 'Global Logout',
    'core.forum.security.hide_access_token' => 'Hide Token',
    'core.forum.security.last_activity' => 'Last activity',
    'core.forum.security.new_access_token_button' => '=> core.ref.new_token',
    'core.forum.security.new_access_token_modal.submit_button' => 'Create Token',
    'core.forum.security.new_access_token_modal.title' => '=> core.ref.new_token',
    'core.forum.security.revoke_access_token' => 'Revoke',
    'core.forum.security.revoke_access_token_confirmation' => '=> core.ref.generic_confirmation_message',
    'core.forum.security.sessions_heading' => 'Active Sessions',
    'core.forum.security.session_terminated' => '{count, plural, one {Session terminated} other {# Sessions terminated}}.',
    'core.forum.security.session_termination_failed' => 'An error occurred while terminating your sessions.',
    'core.forum.security.show_access_token' => 'View Token',
    'core.forum.security.terminate_all_other_sessions' => 'Terminate all other sessions',
    'core.forum.security.terminate_all_other_sessions_confirmation' => '=> core.ref.generic_confirmation_message',
    'core.forum.security.terminate_session' => 'Terminate',
    'core.forum.security.token_revoked' => 'Token revoked.',
    'core.forum.security.token_item_title' => '{title} - {token}',
    'core.forum.security.token_title_placeholder' => '/',
    'core.forum.settings.notification_checkbox_a11y_label_template' => 'Receive "{description}" notifications via {method}',
    'core.forum.settings.notify_by_web_heading' => 'Web',
    'core.forum.sign_up.dismiss_button' => '=> core.ref.okay',
    'core.forum.sign_up.email_placeholder' => '=> core.ref.email',
    'core.forum.user.avatar_remove_button' => '=> core.ref.remove',
    'core.forum.user.avatar_upload_button' => 'Upload',
    'core.forum.user.avatar_upload_tooltip' => 'Upload a new avatar',
    'core.forum.user_controls.toggle_dropdown_accessible_label' => 'Toggle user controls dropdown menu',
    'core.forum.welcome_hero.hide' => 'Hide welcome message',
    'core.lib.debug_button' => 'Debug',
    'core.lib.alert.dismiss_a11y_label' => 'Dismiss alert',
    'core.lib.badge.hidden_tooltip' => 'Hidden',
    'core.lib.dropdown.toggle_dropdown_accessible_label' => 'Toggle dropdown menu',
    'core.lib.data_segment.label' => '{label}:',
    'core.lib.edit_user.nothing_available' => 'You are not allowed to edit this user.',
    'core.lib.error.circular_dependencies_message' => 'Circular dependencies detected: {extensions}. Aborting. Please disable one of the extensions and try again.',
    'core.lib.error.dependent_extensions_message' => 'Cannot disable {extension} until the following dependent extensions are disabled: {extensions}',
    'core.lib.error.extension_initialiation_failed_message' => '{extension} failed to initialize, check the browser console for further information.',
    'core.lib.error.generic_message' => 'Oops! Something went wrong. Please reload the page and try again.',
    'core.lib.error.generic_cross_origin_message' => 'Oops! Something went wrong during a cross-origin request. Please reload the page and try again.',
    'core.lib.error.missing_dependencies_message' => 'Cannot enable {extension} until the following dependencies are enabled: {extensions}',
    'core.lib.error.not_found_message' => 'The requested resource was not found.',
    'core.lib.error.payload_too_large_message' => 'The request payload was too large.',
    'core.lib.error.permission_denied_message' => 'You do not have permission to do that.',
    'core.lib.error.render_failed_message' => 'Sorry, we encountered an error while displaying this content. If you\'re a user, please try again later. If you\'re an administrator, take a look in your Flarum log files for more information.',
    'core.lib.loading_indicator.accessible_label' => '=> core.ref.loading',
    'core.lib.meta_titles.with_page_title' => '{pageNumber, plural, =1 {{pageTitle} - {forumName}} other {{pageTitle}: Page # - {forumName}}}',
    'core.lib.meta_titles.without_page_title' => '{pageNumber, plural, =1 {{forumName}} other {Page # - {forumName}}}',
    'core.lib.modal.close' => 'Close',
    'core.lib.nav.drawer_button' => 'Open Navigation Drawer',
    'core.lib.number_suffix.kilo_text' => 'K',
    'core.lib.number_suffix.mega_text' => 'M',
    'core.lib.series.glue_text' => ', ',
    'core.lib.series.three_text' => '{first}, {second}, and {third}',
    'core.lib.series.two_text' => '{first} and {second}',
    'core.lib.username.deleted_text' => '[deleted]',
    'core.views.admin.extensions.caption' => '=> core.ref.extensions',
    'core.views.admin.extensions.disable' => 'Disable',
    'core.views.admin.extensions.empty' => 'No installed extensions',
    'core.views.admin.extensions.enable' => 'Enable',
    'core.views.admin.extensions.name' => 'Extension Name',
    'core.views.admin.extensions.package_name' => 'Package Name',
    'core.views.admin.extensions.version' => 'Version',
    'core.views.admin.info.caption' => 'Application Info',
    'core.views.confirm_email.submit_button' => '=> core.ref.confirm_email',
    'core.views.confirm_email.text' => 'Click the button below to confirm your account\'s email.',
    'core.views.confirm_email.title' => '=> core.ref.confirm_email',
    'core.views.content.javascript_disabled_message' => 'This site is best viewed in a modern browser with JavaScript enabled.',
    'core.views.content.load_error_message' => 'Something went wrong while trying to load the full version of this site. Try hard-refreshing this page to fix the error.',
    'core.views.content.loading_text' => '=> core.ref.loading',
    'core.views.discussion.previous_page_button' => '=> core.ref.previous_page',
    'core.views.error.csrf_token_mismatch' => 'You have been inactive for too long.',
    'core.views.error.csrf_token_mismatch_return_link' => 'Go back, to try again',
    'core.views.error.invalid_confirmation_token' => 'This confirmation link has already been used or is invalid.',
    'core.views.error.not_authenticated' => 'You do not have permission to access this page. Try again after logging in.',
    'core.views.error.not_found' => 'The page you requested could not be found.',
    'core.views.error.not_found_return_link' => 'Return to {forum}',
    'core.views.error.permission_denied' => 'You do not have permission to access this page.',
    'core.views.error.unknown' => 'An error occurred while trying to load this page.',
    'core.views.index.next_page_button' => '=> core.ref.next_page',
    'core.views.index.previous_page_button' => '=> core.ref.previous_page',
    'core.views.log_out.log_out_confirmation' => 'Are you sure you want to log out of {forum}?',
    'core.api.invalid_filter_type.must_be_numeric_message' => 'The {filter} filter must be numeric.',
    'core.api.invalid_filter_type.must_not_be_array_message' => 'The {filter} filter must not be an array.',
    'core.api.invalid_filter_type.must_not_be_multidimensional_array_message' => 'The {filter} filter must not be a multidimensional array.',
    'core.email.send_test.subject' => 'Flarum Email Test',
    'core.email.send_test.body' => 'Hey {username}!

This is a test email to confirm that your Flarum email configuration is working properly.

If this was you, this email means that your configuration works!

If this was not you, please ignore this email.
',
    'core.ref.change_email' => 'Change Email',
    'core.ref.color' => 'Color',
    'core.ref.confirm_email' => 'Confirm Email',
    'core.ref.custom_footer_text' => 'Add HTML to be displayed at the very bottom of the page.',
    'core.ref.custom_footer_title' => 'Edit Custom Footer',
    'core.ref.custom_header_text' => 'Add HTML to be displayed at the very top of the page, above Flarum\'s own header.',
    'core.ref.custom_header_title' => 'Edit Custom Header',
    'core.ref.delete' => 'Delete',
    'core.ref.delete_forever' => 'Delete Forever',
    'core.ref.email' => 'Email',
    'core.ref.extensions' => 'Extensions',
    'core.ref.generic_confirmation_message' => 'Are you sure you want to proceed? This action cannot be undone.',
    'core.ref.icon' => 'Icon',
    'core.ref.icon_text' => 'Enter the name of any <a>FontAwesome</a> icon class, <em>including</em> the <code>fas fa-</code> prefix.',
    'core.ref.load_more' => 'Load More',
    'core.ref.loading' => 'Loading...',
    'core.ref.never' => 'Never',
    'core.ref.new_token' => 'New Token',
    'core.ref.next_page' => 'Next Page',
    'core.ref.okay' => 'OK',
    'core.ref.previous_page' => 'Previous Page',
    'core.ref.remove' => 'Remove',
    'core.ref.restore' => 'Restore',
    'core.ref.save_changes' => 'Save Changes',
    'core.ref.search_users' => 'Search users',
    'core.ref.some_others' => '{count, plural, one {# other} other {# others}}',
    'core.ref.users' => 'Users',
    'core.ref.view' => 'View',
    'core.ref.you' => 'You',
    'core.group.admin' => 'Admin',
    'core.group.admins' => 'Admins',
    'core.group.guest' => 'Guest',
    'core.group.guests' => 'Guests',
    'core.group.member' => 'Member',
    'core.group.members' => 'Members',
    'core.group.mod' => 'Mod',
    'core.group.mods' => 'Mods',
    'validation.accepted' => 'The :attribute must be accepted.',
    'validation.active_url' => 'The :attribute is not a valid URL.',
    'validation.after' => 'The :attribute must be a date after :date.',
    'validation.after_or_equal' => 'The :attribute must be a date after or equal to :date.',
    'validation.alpha' => 'The :attribute must only contain letters.',
    'validation.alpha_dash' => 'The :attribute must only contain letters, numbers, dashes and underscores.',
    'validation.alpha_num' => 'The :attribute must only contain letters and numbers.',
    'validation.array' => 'The :attribute must be an array.',
    'validation.before' => 'The :attribute must be a date before :date.',
    'validation.before_or_equal' => 'The :attribute must be a date before or equal to :date.',
    'validation.between.numeric' => 'The :attribute must be between :min and :max.',
    'validation.between.file' => 'The :attribute must be between :min and :max kilobytes.',
    'validation.between.string' => 'The :attribute must be between :min and :max characters.',
    'validation.between.array' => 'The :attribute must have between :min and :max items.',
    'validation.boolean' => 'The :attribute field must be true or false.',
    'validation.confirmed' => 'The :attribute confirmation does not match.',
    'validation.date' => 'The :attribute is not a valid date.',
    'validation.date_equals' => 'The :attribute must be a date equal to :date.',
    'validation.date_format' => 'The :attribute does not match the format :format.',
    'validation.different' => 'The :attribute and :other must be different.',
    'validation.digits' => 'The :attribute must be :digits digits.',
    'validation.digits_between' => 'The :attribute must be between :min and :max digits.',
    'validation.dimensions' => 'The :attribute has invalid image dimensions.',
    'validation.distinct' => 'The :attribute field has a duplicate value.',
    'validation.email' => 'The :attribute must be a valid email address.',
    'validation.ends_with' => 'The :attribute must end with one of the following: :values.',
    'validation.exists' => 'The selected :attribute is invalid.',
    'validation.file' => 'The :attribute must be a file.',
    'validation.file_too_large' => 'The :attribute is too large.',
    'validation.file_upload_failed' => 'The :attribute failed to upload.',
    'validation.filled' => 'The :attribute field must have a value.',
    'validation.gt.numeric' => 'The :attribute must be greater than :value.',
    'validation.gt.file' => 'The :attribute must be greater than :value kilobytes.',
    'validation.gt.string' => 'The :attribute must be greater than :value characters.',
    'validation.gt.array' => 'The :attribute must have more than :value items.',
    'validation.gte.numeric' => 'The :attribute must be greater than or equal :value.',
    'validation.gte.file' => 'The :attribute must be greater than or equal :value kilobytes.',
    'validation.gte.string' => 'The :attribute must be greater than or equal :value characters.',
    'validation.gte.array' => 'The :attribute must have :value items or more.',
    'validation.image' => 'The :attribute must be an image.',
    'validation.in' => 'The selected :attribute is invalid.',
    'validation.in_array' => 'The :attribute field does not exist in :other.',
    'validation.integer' => 'The :attribute must be an integer.',
    'validation.ip' => 'The :attribute must be a valid IP address.',
    'validation.ipv4' => 'The :attribute must be a valid IPv4 address.',
    'validation.ipv6' => 'The :attribute must be a valid IPv6 address.',
    'validation.json' => 'The :attribute must be a valid JSON string.',
    'validation.lt.numeric' => 'The :attribute must be less than :value.',
    'validation.lt.file' => 'The :attribute must be less than :value kilobytes.',
    'validation.lt.string' => 'The :attribute must be less than :value characters.',
    'validation.lt.array' => 'The :attribute must have less than :value items.',
    'validation.lte.numeric' => 'The :attribute must be less than or equal :value.',
    'validation.lte.file' => 'The :attribute must be less than or equal :value kilobytes.',
    'validation.lte.string' => 'The :attribute must be less than or equal :value characters.',
    'validation.lte.array' => 'The :attribute must not have more than :value items.',
    'validation.max.numeric' => 'The :attribute must not be greater than :max.',
    'validation.max.file' => 'The :attribute must not be greater than :max kilobytes.',
    'validation.max.string' => 'The :attribute must not be greater than :max characters.',
    'validation.max.array' => 'The :attribute must not have more than :max items.',
    'validation.mimes' => 'The :attribute must be a file of type: :values.',
    'validation.mimetypes' => 'The :attribute must be a file of type: :values.',
    'validation.min.numeric' => 'The :attribute must be at least :min.',
    'validation.min.file' => 'The :attribute must be at least :min kilobytes.',
    'validation.min.string' => 'The :attribute must be at least :min characters.',
    'validation.min.array' => 'The :attribute must have at least :min items.',
    'validation.multiple_of' => 'The :attribute must be a multiple of :value.',
    'validation.not_in' => 'The selected :attribute is invalid.',
    'validation.not_regex' => 'The :attribute format is invalid.',
    'validation.numeric' => 'The :attribute must be a number.',
    'validation.present' => 'The :attribute field must be present.',
    'validation.regex' => 'The :attribute format is invalid.',
    'validation.required' => 'The :attribute field is required.',
    'validation.required_if' => 'The :attribute field is required when :other is :value.',
    'validation.required_unless' => 'The :attribute field is required unless :other is in :values.',
    'validation.required_with' => 'The :attribute field is required when :values is present.',
    'validation.required_with_all' => 'The :attribute field is required when :values are present.',
    'validation.required_without' => 'The :attribute field is required when :values is not present.',
    'validation.required_without_all' => 'The :attribute field is required when none of :values are present.',
    'validation.prohibited' => 'The :attribute field is prohibited.',
    'validation.prohibited_if' => 'The :attribute field is prohibited when :other is :value.',
    'validation.prohibited_unless' => 'The :attribute field is prohibited unless :other is in :values.',
    'validation.same' => 'The :attribute and :other must match.',
    'validation.size.numeric' => 'The :attribute must be :size.',
    'validation.size.file' => 'The :attribute must be :size kilobytes.',
    'validation.size.string' => 'The :attribute must be :size characters.',
    'validation.size.array' => 'The :attribute must contain :size items.',
    'validation.starts_with' => 'The :attribute must start with one of the following: :values.',
    'validation.string' => 'The :attribute must be a string.',
    'validation.timezone' => 'The :attribute must be a valid zone.',
    'validation.unique' => 'The :attribute has already been taken.',
    'validation.uploaded' => 'The :attribute failed to upload.',
    'validation.url' => 'The :attribute format is invalid.',
    'validation.uuid' => 'The :attribute must be a valid UUID.',
    'validation.attributes.email' => 'email',
    'validation.attributes.title' => 'title',
    'validation.attributes.content' => 'content',
    'validation.attributes.name_singular' => 'singular name',
    'validation.attributes.name_plural' => 'plural name',
    'validation.attributes.tag_count_primary' => 'number of primary tags',
    'validation.attributes.tag_count_secondary' => 'number of secondary tags',
    'flarum-flags.forum.flag_post.dismiss_button' => '=> core.ref.okay',
    'flarum-flags.forum.flag_post.reason_spam_label' => 'Spam',
    'flarum-approval.forum.badge.awaiting_approval_tooltip' => '=> flarum-approval.ref.awaiting_approval',
    'flarum-approval.ref.awaiting_approval' => 'Awaiting approval',
    'flarum-tags.admin.edit_tag.icon_text' => '=> core.ref.icon_text',
    'flarum-tags.admin.edit_tag.slug_label' => 'Slug',
    'flarum-tags.admin.nav.tags_text' => 'Manage the list of tags available to organise discussions with.',
    'flarum-tags.admin.permissions.allow_edit_tags_label' => 'Allow tag editing',
    'flarum-tags.admin.permissions.bypass_tag_counts_label' => 'Bypass tag requirements',
    'flarum-tags.admin.permissions.restrict_by_tag_heading' => 'Restrict by Tag',
    'flarum-tags.admin.permissions.tag_discussions_label' => 'Tag discussions',
    'flarum-tags.admin.tag_settings.range_separator_text' => ' to ',
    'flarum-tags.admin.tag_settings.required_primary_heading' => 'Required Number of Primary Tags',
    'flarum-tags.admin.tag_settings.required_primary_text' => 'Enter the minimum and maximum number of primary tags that may be applied to a discussion.',
    'flarum-tags.admin.tag_settings.required_secondary_heading' => 'Required Number of Secondary Tags',
    'flarum-tags.admin.tag_settings.required_secondary_text' => 'Enter the minimum and maximum number of secondary tags that may be applied to a discussion.',
    'flarum-tags.admin.tag_settings.title' => 'Tag Settings',
    'flarum-tags.admin.tags.about_tags_text' => 'Tags are used to categorize discussions. Primary tags are like traditional forum categories: they can be arranged in a two-level hierarchy. Secondary tags do not have hierarchy or order, and are useful for micro-categorization.',
    'flarum-tags.admin.tags.create_primary_tag_button' => 'Create Primary Tag',
    'flarum-tags.admin.tags.create_secondary_tag_button' => 'Create Secondary Tag',
    'flarum-tags.admin.tags.primary_heading' => 'Primary Tags',
    'flarum-tags.admin.tags.secondary_heading' => 'Secondary Tags',
    'flarum-tags.forum.all_tags.meta_description_text' => 'All Tags',
    'flarum-tags.forum.choose_tags.edit_title' => 'Edit Tags for {title}',
    'flarum-tags.forum.header.back_to_tags_tooltip' => 'Back to Tag List',
    'flarum-tags.forum.index.more_link' => 'More...',
    'flarum-tags.forum.index.untagged_link' => 'Untagged',
    'flarum-tags.lib.deleted_tag_text' => 'Deleted',
    'flarum-tags.lib.tag_selection_modal.bypass_requirements' => 'Bypass tag requirements',
    'flarum-tags.lib.tag_selection_modal.choose_primary_placeholder' => '{count, plural, one {Choose a primary tag} other {Choose # primary tags}}',
    'flarum-tags.lib.tag_selection_modal.choose_secondary_placeholder' => '=> flarum-tags.ref.choose_tags_placeholder',
    'flarum-tags.lib.tag_selection_modal.choose_tags_placeholder' => '=> flarum-tags.ref.choose_tags_placeholder',
    'flarum-tags.lib.tag_selection_modal.submit_button' => '=> core.ref.okay',
    'flarum-tags.ref.choose_tags_placeholder' => '{count, plural, one {Choose 1 more tag} other {Choose # more tags}}',
    'flarum-tags.ref.name' => 'Name',
    'flarum-tags.ref.tags' => 'Tags',
    'fof-linguist.admin.permissions.view_string_keys' => 'View translation string keys',
    'fof-linguist.admin.tabs.strings' => 'Translations',
    'fof-linguist.admin.tabs.coverage' => 'Coverage',
    'fof-linguist.admin.tabs.export' => 'Export',
    'fof-linguist.admin.tabs.import' => 'Import',
    'fof-linguist.admin.buttons.apply' => 'Apply',
    'fof-linguist.admin.buttons.reset' => 'Restore original',
    'fof-linguist.admin.buttons.copy-original' => 'Copy original text',
    'fof-linguist.admin.buttons.load-more' => 'Load more',
    'fof-linguist.admin.buttons.delete-redundant' => 'Delete redundant translations',
    'fof-linguist.admin.buttons.delete-redundant-confirm' => 'This will delete {count} translations that have identical original and custom values. This can be useful to clean up after a language pack update.
',
    'fof-linguist.admin.buttons.delete-all' => 'Delete all translations',
    'fof-linguist.admin.buttons.delete-all-confirm' => 'This will delete ALL of your {count} custom translations. Make sure you have exported or backed up everything you might have wanted to keep.
',
    'fof-linguist.admin.locales.all' => 'All',
    'fof-linguist.admin.placeholder.not-translated' => 'Not translated',
    'fof-linguist.admin.placeholder.all-locales' => 'A text defined here will be shown in all languages',
    'fof-linguist.admin.placeholder.hint' => 'Original value:',
    'fof-linguist.admin.filters.search' => 'Search translation strings...',
    'fof-linguist.admin.filters.with-own-translations' => 'My translations',
    'fof-linguist.admin.filters.missing' => 'Find missing translations',
    'fof-linguist.admin.filters.missing-middle-label' => 'translations in',
    'fof-linguist.admin.filters.negation-options.with' => 'With',
    'fof-linguist.admin.filters.negation-options.without' => 'Without',
    'fof-linguist.admin.filters.type-options.any' => 'Original or Custom',
    'fof-linguist.admin.filters.type-options.original' => 'Original',
    'fof-linguist.admin.filters.type-options.own' => 'Custom',
    'fof-linguist.admin.filters.operation-options.or' => 'Either of',
    'fof-linguist.admin.filters.operation-options.and' => 'All of',
    'fof-linguist.admin.filters.for-extension' => 'For extension',
    'fof-linguist.admin.filters.frontend' => 'For frontend',
    'fof-linguist.admin.filters.frontend-all-except-admin' => 'All except Admin',
    'fof-linguist.admin.filters.mass-edit' => 'Mass edit',
    'fof-linguist.admin.filters.results' => 'Showing {shown} of {total} matching translations',
    'fof-linguist.admin.clear-cache.text' => 'New translations have not yet been applied. Note: clearing the cache can momentarily slow down your forum.
',
    'fof-linguist.admin.clear-cache.button' => 'Clear cache now',
    'fof-linguist.admin.coverage.column-options.locale' => 'By language',
    'fof-linguist.admin.coverage.column-options.namespace' => 'By frontend',
    'fof-linguist.admin.coverage.total-options.percent' => 'Percent',
    'fof-linguist.admin.coverage.total-options.count' => 'Count',
    'fof-linguist.admin.coverage.columns.namespace' => 'Namespace',
    'fof-linguist.admin.coverage.columns.total' => 'Total',
    'fof-linguist.admin.coverage.columns.all-except-admin' => 'Forum and other frontends',
    'fof-linguist.admin.coverage.columns.all-frontends' => 'Show all frontends',
    'fof-linguist.admin.coverage.count.percent' => '{percent} %',
    'fof-linguist.admin.coverage.count.total' => '{translated} / {total}',
    'fof-linguist.admin.coverage.count.details' => '{total} total / {original} original / {custom} custom',
    'fof-linguist.admin.coverage.all-namespaces' => 'All',
    'fof-linguist.admin.coverage.apply-missing-filter' => 'Show matching missing translations',
    'fof-linguist.admin.export.title' => 'Export',
    'fof-linguist.admin.export.warning' => 'The export format uses Flarum\'s Yaml-based translation files and is designed to share translations between forums and with language pack maintainers. The format is not designed to move all translations to a new forum. Depending on your use case, copying the database directly might be a better idea.
',
    'fof-linguist.admin.export.locale' => 'Locale',
    'fof-linguist.admin.export.locale-all' => 'Pseudo-locale "All"',
    'fof-linguist.admin.export.namespace' => 'Namespace',
    'fof-linguist.admin.export.namespace-all' => 'All',
    'fof-linguist.admin.export.include-originals' => 'Include original translations',
    'fof-linguist.admin.export.include-all' => 'Include translations defined for "All" languages',
    'fof-linguist.admin.export.output' => 'Output',
    'fof-linguist.admin.export.output-loading' => 'Loading output...',
    'fof-linguist.admin.export.output-empty' => 'Empty output',
    'fof-linguist.admin.export.download' => 'Download',
    'fof-linguist.admin.import.title' => 'Import',
    'fof-linguist.admin.import.input' => 'Input',
    'fof-linguist.admin.import.input-placeholder' => 'Drag and drop or paste a Yaml file here',
    'fof-linguist.admin.import.locale' => 'Locale',
    'fof-linguist.admin.import.locale-all' => 'Pseudo-locale "All"',
    'fof-linguist.admin.import.override-existing' => 'Override my existing custom translations',
    'fof-linguist.admin.import.submit' => 'Import',
    'fof-linguist.admin.import.results' => 'The import is finished. {imported} strings have been imported and {identical} identical strings were skipped. The page will now refresh to show the new translations.
',
    'fof-linguist.admin.import.results-with-ignore' => 'The import is finished. {imported} strings have been imported, {ignored} existing strings have been ignored and {identical} identical strings were skipped. The page will now refresh to show the new translations.
',
    'fof-linguist.admin.known-namespace.core' => 'Flarum Core',
    'fof-linguist.admin.known-namespace.validation' => 'Validation Errors',
    'fof-linguist.admin.known-frontend.forum' => 'Forum',
    'fof-linguist.admin.known-frontend.admin' => 'Admin',
    'fof-linguist.admin.known-frontend.lib' => 'Lib (used on both Forum and Admin)',
    'fof-linguist.admin.known-frontend.ref' => 'Ref (re-used in other keys)',
    'fof-linguist.admin.known-frontend.api' => 'API',
    'flarum-suspend.admin.permissions.suspend_users_label' => 'Suspend users',
    'flarum-suspend.forum.notifications.user_suspended_text' => 'You have been suspended for {timeReadable}',
    'flarum-suspend.forum.notifications.user_suspended_indefinite_text' => 'You have been suspended indefinitely',
    'flarum-suspend.forum.notifications.user_unsuspended_text' => 'You have been unsuspended',
    'flarum-suspend.forum.suspension_info.dismiss_button' => 'Dismiss',
    'flarum-suspend.forum.suspension_info.indefinite' => 'This is an indefinite suspension',
    'flarum-suspend.forum.suspension_info.limited' => 'This suspension will be in force until {date}',
    'flarum-suspend.forum.suspension_info.title' => 'This account is suspended',
    'flarum-suspend.forum.suspend_user.display_message' => 'Display message for user',
    'flarum-suspend.forum.suspend_user.indefinitely_label' => 'Suspended indefinitely',
    'flarum-suspend.forum.suspend_user.limited_time_label' => 'Suspended for a limited time...',
    'flarum-suspend.forum.suspend_user.not_suspended_label' => 'Not suspended',
    'flarum-suspend.forum.suspend_user.placeholder_optional' => 'Optional',
    'flarum-suspend.forum.suspend_user.reason' => 'Reason for suspension',
    'flarum-suspend.forum.suspend_user.status_heading' => 'Suspension Status',
    'flarum-suspend.forum.suspend_user.submit_button' => '=> core.ref.save_changes',
    'flarum-suspend.forum.user_badge.suspended_tooltip' => 'Suspended',
    'flarum-suspend.forum.user_controls.suspend_button' => 'Suspend',
    'flarum-suspend.email.no_reason_given' => 'No reason was given for this suspension.',
    'flarum-suspend.email.suspended.subject' => 'Your account has been suspended',
    'flarum-suspend.email.suspended.body' => 'Hey {recipient_display_name},

You have been suspended for the following reason:

---
{suspension_message}
---
',
    'flarum-suspend.email.unsuspended.subject' => 'Your account has been unsuspended',
    'flarum-suspend.email.unsuspended.body' => 'Hey {recipient_display_name},

You have been unsuspended. You can head back to the forum by clicking on the following link:

{forum_url}
',
    'flarum-subscriptions.forum.badge.ignoring_tooltip' => '=> flarum-subscriptions.ref.ignoring',
    'flarum-subscriptions.forum.discussion_controls.unignore_button' => 'Unignore',
    'flarum-subscriptions.forum.sub_controls.follow_button' => '=> flarum-subscriptions.ref.follow',
    'flarum-subscriptions.forum.sub_controls.ignoring_button' => '=> flarum-subscriptions.ref.ignoring',
    'flarum-subscriptions.ref.ignoring' => 'Ignoring',
    'flarum-sticky.forum.discussion_controls.sticky_button' => '=> flarum-sticky.ref.sticky',
    'flarum-statistics.admin.date_selection_modal.description' => 'Pick a custom date range to display statistics for. Loading data may take
multiple minutes on forums with a lot of activity.
',
    'flarum-statistics.admin.date_selection_modal.end_date' => 'End date (inclusive)',
    'flarum-statistics.admin.date_selection_modal.errors.end_before_start' => 'The end date must be after the start date.',
    'flarum-statistics.admin.date_selection_modal.start_date' => 'Start date (inclusive)',
    'flarum-statistics.admin.date_selection_modal.submit_button' => 'Confirm date range',
    'flarum-statistics.admin.date_selection_modal.title' => 'Choose custom date range',
    'flarum-statistics.admin.statistics.discussions_heading' => '=> core.ref.discussions',
    'flarum-statistics.admin.statistics.export_chart_button' => 'Export chart to SVG',
    'flarum-statistics.admin.statistics.last_12_months_label' => 'Last 12 months',
    'flarum-statistics.admin.statistics.mini_heading' => 'Forum statistics',
    'flarum-statistics.admin.statistics.custom_label' => 'Choose custom range...',
    'flarum-statistics.admin.statistics.custom_label_specified' => '{fromDate} to {toDate}',
    'flarum-statistics.admin.statistics.loading' => '=> core.ref.loading',
    'flarum-statistics.admin.statistics.today_label' => 'Today',
    'flarum-statistics.admin.statistics.total_label' => 'Total',
    'flarum-statistics.admin.statistics.users_heading' => '=> core.ref.users',
    'flarum-statistics.admin.statistics.view_full' => 'View more statistics',
    'flarum-statistics.admin.statistics.no_data' => 'There is no data available for this date range.',
    'flarum-statistics.admin.statistics.current_period' => 'Current period',
    'flarum-statistics.admin.statistics.previous_period' => 'Previous period',
    'flarum-pusher.admin.pusher_settings.app_cluster_label' => 'Cluster',
    'flarum-pusher.admin.pusher_settings.app_id_label' => 'App ID',
    'flarum-pusher.admin.pusher_settings.app_key_label' => 'App Key',
    'flarum-pusher.admin.pusher_settings.app_secret_label' => 'App Secret',
    'flarum-pusher.admin.pusher_settings.title' => 'Pusher Settings',
    'flarum-pusher.forum.discussion_list.show_updates_text' => '{count, plural, one {Show # updated discussion} other {Show # updated discussions}}',
    'flarum-mentions.admin.permissions.mention_groups_label' => 'Mention groups',
    'flarum-mentions.admin.settings.allow_username_format_text' => 'The current format for user mentions is @"Display Name"#ID.
This setting allows using the old format of @Username, however it will still be converted to the new format upon saving.
',
    'flarum-mentions.forum.mentioned_by.load_more_button' => '=> core.ref.load_more',
    'flarum-mentions.forum.notifications.others_text' => '=> core.ref.some_others',
    'flarum-mentions.forum.post.others_text' => '=> core.ref.some_others',
    'flarum-mentions.forum.post_mention.deleted_text' => '[unknown]',
    'flarum-mentions.forum.group_mention.deleted_text' => '[unknown group]',
    'flarum-markdown.lib.composer.bold_tooltip' => 'Add bold text',
    'flarum-markdown.lib.composer.code_tooltip' => 'Insert code',
    'flarum-markdown.lib.composer.header_tooltip' => 'Add header text',
    'flarum-markdown.lib.composer.image_tooltip' => 'Add an image',
    'flarum-markdown.lib.composer.italic_tooltip' => 'Add italic text',
    'flarum-markdown.lib.composer.link_tooltip' => 'Add a link',
    'flarum-markdown.lib.composer.ordered_list_tooltip' => 'Add a numbered list',
    'flarum-markdown.lib.composer.quote_tooltip' => 'Insert a quote',
    'flarum-markdown.lib.composer.spoiler_tooltip' => 'Insert a spoiler',
    'flarum-markdown.lib.composer.strikethrough_tooltip' => 'Add strikethrough text',
    'flarum-markdown.lib.composer.unordered_list_tooltip' => 'Add a bulleted list',
    'flarum-lock.admin.permissions.lock_discussions_label' => 'Lock discussions',
    'flarum-lock.forum.badge.locked_tooltip' => 'Locked',
    'flarum-lock.forum.discussion_controls.unlock_button' => 'Unlock',
    'flarum-likes.forum.notifications.others_text' => '=> core.ref.some_others',
    'flarum-likes.forum.post.others_link' => '=> core.ref.some_others',
    'flarum-emoji.forum.composer.emoji_tooltip' => 'Insert emoji',
    'flarum-emoji.forum.composer.type_to_search_text' => 'Type to search for an emoji',
    'flarum-bbcode.forum.quote.wrote' => 'wrote',
    'askvortsov-pwa.admin.nav.pwa_button' => 'Progressive Web App',
    'askvortsov-pwa.admin.nav.pwa_text' => 'Configure Flarum to run as an Progressive Web App, installable on mobile devices.',
    'askvortsov-pwa.admin.pwa.about.description_label' => 'Description',
    'askvortsov-pwa.admin.pwa.about.description_text' => 'You can set the description on the \'Basics\' page in your admin dashboard.',
    'askvortsov-pwa.admin.pwa.about.long_name_label' => 'Long name',
    'askvortsov-pwa.admin.pwa.about.long_name_text' => 'The name of the web application displayed to the user.',
    'askvortsov-pwa.admin.pwa.about.heading' => 'About',
    'askvortsov-pwa.admin.pwa.about.short_name_label' => 'Short name',
    'askvortsov-pwa.admin.pwa.about.short_name_text' => 'The name of the application displayed to the user if there is not enough space for the long name.',
    'askvortsov-pwa.admin.pwa.colors.heading' => 'Colors',
    'askvortsov-pwa.admin.pwa.colors.background_color_label' => 'Background color',
    'askvortsov-pwa.admin.pwa.colors.background_color_text' => 'This is used as a placeholder color for the splash screen that\'s displayed while your PWA is being loaded. It is not used when the app is actually loaded.',
    'askvortsov-pwa.admin.pwa.colors.theme_color_label' => 'Theme color',
    'askvortsov-pwa.admin.pwa.colors.theme_color_text' => 'This color is sometimes used by devices when displaying your app, for example on Android\'s task switcher, as the color that surround the site.',
    'askvortsov-pwa.admin.pwa.maintenance.heading' => 'Maintenance',
    'askvortsov-pwa.admin.pwa.maintenance.debug_label' => 'Debug mode?',
    'askvortsov-pwa.admin.pwa.maintenance.reset_vapid_text' => 'This will regenerate VAPID keys, and delete any existing subscriptions using the current VAPID keys.',
    'askvortsov-pwa.admin.pwa.maintenance.reset_vapid_confirm' => 'Resetting VAPID keys will remove any subscriptions using the existing keys, so users won\'t receive any notifications until the next time they visit your site. This should only be done when setting up push notifications for the first time, or if push notifications aren\'t working at all and there\'s a warning about missing VAPID keys above.',
    'askvortsov-pwa.admin.pwa.maintenance.reset_vapid_success' => 'Successfully reset VAPID keys. {count} subscriptions were reset. Reload the page to see an updated status check report.',
    'askvortsov-pwa.admin.pwa.other.heading' => 'Other',
    'askvortsov-pwa.admin.pwa.other.force_portrait_text' => 'Force portait orientation?',
    'askvortsov-pwa.admin.pwa.other.push_notif_preference_default_to_email_label' => 'Default Push Preferences to Email?',
    'askvortsov-pwa.admin.pwa.other.push_notif_preference_default_to_email_text' => 'If true, users will have push notifications enabled by default for all notification types where email notifications are enabled by default. If false, users will have push notifications disabled by default.',
    'askvortsov-pwa.admin.pwa.other.user_max_subscriptions_label' => 'Max Push Subscriptions Per User',
    'askvortsov-pwa.admin.pwa.other.user_max_subscriptions_text' => 'How many push subscriptions should each user be able to have at a time? When a user receives a push notification, each subscription will result in an API call. Each subscription typically corresponds to a browser the user has used.',
    'askvortsov-pwa.admin.pwa.heading' => 'Progressive Web App Configuration',
    'askvortsov-pwa.admin.pwa.text' => 'Configure your Flarum site to run as a progressive web app! Please note that this doesn\'t automatically put your site in the app store. Instead, this means that users have an \'Add to Homescreen\' option for your site. We provide some status checks, however, the best way to test this is to try and install it (search on google for instructions on how to install progressive web apps). Also, please keep in mind that \'install this PWA\' popups are controlled by browsers, and cannot be triggered by developers/admins/programs. I recommend including instructions for how to install a PWA in your site\'s documentation.',
    'askvortsov-pwa.admin.pwa.status_check_heading' => 'Status Check',
    'askvortsov-pwa.admin.pwa.logo_heading' => 'Logos and Icons',
    'askvortsov-pwa.admin.pwa.logo_text' => 'You must upload at least one logo for your progressive web app to be installable. Please note that all logos must be square; if they are not, they will be resized and possibly stretched.

There are a number of size options available below. I would recommend trying to upload a logo to as many as you can: this supports more devices.

Please note that you can upload 1 large logo to inputs for smaller logos. For instance, you can upload a 1000px x 1000px logo to ALL the file inputs below. However, if you try to upload a 50px x 50px logo to the 512x512 input, it will be stretched a lot.
',
    'askvortsov-pwa.admin.pwa.logo_size_text' => 'Upload a logo which will be scaled to {size} pixels by {size} pixels size.',
    'askvortsov-pwa.admin.pwa.submit_button' => 'Save Settings',
    'askvortsov-pwa.admin.pwa.refreshed_message' => 'PWA config refreshed successfully.',
    'askvortsov-pwa.admin.status.config_no_https' => 'The url in your config.php file isn\'t using HTTPS. HTTPS is required for Progressive Web Apps to work.',
    'askvortsov-pwa.admin.status.possible_https_disabled' => 'Your site might not be running on HTTPS. Clearing your cache (admin dashboard page => tools button) might help. If it is, ignore this. If it isn\'t, keep in mind that HTTPS is required for Progressive Web Apps to work.',
    'askvortsov-pwa.admin.status.no_logo' => 'You must upload at least one logo, with a size of at least 144x144px, for the PWA to be installable.',
    'askvortsov-pwa.admin.status.no_name' => 'You must provide a full name for your app to work.',
    'askvortsov-pwa.admin.status.no_vapid_keys' => 'No VAPID keys found. These are required for push notifications to send. You can reset VAPID keys below.',
    'askvortsov-pwa.admin.status.key_gen_failed' => 'Generation of keys needed for push notifications has failed. The full error message was: {error}',
    'askvortsov-pwa.admin.status.suggest_gmp' => 'The gmp PHP extension doesn\'t seem to be enabled on your server. It\'s not strictly necessary, but can improve performance and is recommended. Some shared hosts might not support it though.',
    'askvortsov-pwa.admin.status.success' => 'No Potential Issues Found!',
    'askvortsov-pwa.forum.settings.push_header' => 'Push',
    'askvortsov-pwa.forum.settings.pwa_notifications.access_default_button' => 'Opt In',
    'askvortsov-pwa.forum.settings.pwa_notifications.access_denied' => 'You must adjust your browser settings to receive push notifications on this device.',
    'askvortsov-pwa.forum.settings.pwa_notifications.no_browser_support' => 'This browser does not support push notifications for progressive web apps.',
    'askvortsov-pwa.views.offline.header' => 'Network connection error',
    'askvortsov-pwa.views.offline.text' => 'This app requires a network connection; it cannot be used offline. Please check your connection.',
  ),
  'messages' => 
  array (
    'askvortsov-pwa.admin.pwa.maintenance.debug_text' => 'Kjo do të regjistrojë informacione rreth njoftimeve në "magazina/regjistra". Në përgjithsi duhet të çaktivizohet për të shmangur plotësimin e panevojshëm të regjistrave.',
    'askvortsov-pwa.forum.alerts.optin' => 'Ju keni aktivizuar njoftimet push, por nuk e keni konfiguruar këtë pajisje.',
    'askvortsov-pwa.forum.alerts.optin_button' => 'Konfiguro',
    'askvortsov-pwa.forum.discussion_controls.share_button' => 'Shpërndaj',
    'askvortsov-pwa.forum.post_controls.share_api.title' => 'Përgjigjia e {username} për {title}\'',
    'askvortsov-pwa.forum.post_controls.share_button' => 'Shpërndaj',
    'askvortsov-pwa.forum.settings.pwa_notifications.access_default' => 'Aktivizo njoftimet / notifications në pajisjen tuaj',
    'askvortsov-pwa.forum.settings.pwa_notifications.access_denied_button' => 'Mëso si',
    'askvortsov-pwa.forum.settings.pwa_notifications.no_browser_support_button' => 'Mëso më tepër',
    'askvortsov-pwa.forum.user_controls.share_button' => 'Shpërndaj',
    'core.admin.basics.all_discussions_label' => 'Të gjitha diskutimet',
    'core.admin.basics.welcome_banner_text' => 'Konfiguro tekstin që shfaqet në baner në faqen "Të gjitha diskutimet". Përdoreni këtë për të mirëpritur mysafirët në forumin tuaj.',
    'core.admin.create_user.password_placeholder' => 'Fjalëkalimi',
    'core.admin.create_user.use_random_password' => 'Gjenero fjalëkalim të rastësishëm',
    'core.admin.create_user.username_placeholder' => 'Emri i përdoruesit',
    'core.admin.edit_css.submit_button' => 'Ruaj ndryshimet',
    'core.admin.edit_footer.submit_button' => 'Ruaj ndryshimet',
    'core.admin.edit_group.color_label' => 'Ngjyra',
    'core.admin.edit_group.delete_button' => 'Fshij grupin',
    'core.admin.edit_group.name_label' => 'Emri',
    'core.admin.edit_group.submit_button' => 'Ruaj ndryshimet',
    'core.admin.edit_group.title' => 'Krijo një grup',
    'core.admin.email.mail_password_label' => 'Fjalëkalimi',
    'core.admin.email.mail_username_label' => 'Emri i përdoruesit',
    'core.admin.header.log_out_button' => 'Dil',
    'core.admin.nav.categories.discussion' => 'Diskutim',
    'core.admin.permissions_controls.allow_until_reply_button' => 'Deri në përgjigjen tjetër',
    'core.admin.permissions.allow_hide_own_posts_label' => 'Lejo fshirjen e postimeve të mia',
    'core.admin.permissions.allow_post_editing_label' => 'Lejo redaktimin e postimit',
    'core.admin.permissions.delete_discussions_forever_label' => 'Delete discussions forever',
    'core.admin.permissions.delete_discussions_label' => 'Fshini diskutimet ',
    'core.admin.permissions.delete_posts_forever_label' => 'Fshini postimet përgjithmonë',
    'core.admin.permissions.delete_posts_label' => 'Fshiji postimet',
    'core.admin.permissions.edit_posts_label' => 'Modifiko postimet',
    'core.admin.permissions.post_without_throttle_label' => 'Përgjigju disa herë pa pritur',
    'core.admin.permissions.rename_discussions_label' => 'Riemërto diskutimet',
    'core.admin.permissions.reply_to_discussions_label' => 'Përgjigju diskutimeve',
    'core.admin.permissions.sign_up_label' => 'Regjistrohu',
    'core.admin.permissions.start_discussions_label' => 'Nis diskutim',
    'core.admin.permissions.view_forum_label' => 'Shiko forumin (diskutimet dhe përdoruesit)',
    'core.admin.permissions.view_post_ips_label' => 'Shikoni adresat IP të postimit',
    'core.admin.users.grid.columns.edit_user.button' => 'Modifiko',
    'core.admin.users.grid.columns.edit_user.title' => 'Modifiko përdorues',
    'core.admin.users.grid.columns.edit_user.tooltip' => 'Modifiko {emër përdoruesi}',
    'core.admin.users.grid.columns.join_time.title' => 'Regjistruar',
    'core.admin.users.grid.columns.username.profile_link_tooltip' => 'Vizito profilin e {emrit të përdoruesit}',
    'core.admin.users.grid.columns.username.title' => 'Emri i përdoruesit',
    'core.api.invalid_username_message' => 'Emri i përdoruesit mund të përmbajë vetëm shkronja, numra dhe viza.',
    'core.email.activate_account.body' => 'Përshëndetje {username}!

Ju sapo jeni regjistruar në {forum} me këtë adresë emaili.

Nëse veprimi është bërë nga ju, ju lutem klikoni linkun më poshtë dhe llogaria juaj do të aktivizohet menjëherë:
{url}

Nëse nuk e keni kryer ju regjistrimin, jeni të lutur ta injoroni këtë email.

Faleminderit,
Forumi i Shkollës së Magjistraturës',
    'core.email.activate_account.subject' => 'Aktivizo llogarinë tuaj të re',
    'core.email.confirm_email.body' => 'Përshëndetje {username}!

Ju sapo keni ndërruar adresën e email të {forum} në këtë adresë që po ju shkruajmë.

Nëse këtë veprim e keni kryer ju, ju lutem klikoni linkun më poshtë për ta konfirmuar veprimin:
{url}

Në të kundërt, jeni të lutur ta injoroni këtë email.',
    'core.email.confirm_email.subject' => 'Konfirmo Adresën Tuaj Të Re Të Emailit',
    'core.email.reset_password.body' => 'Hej {username}!

Dikush (shpresojmë se ju!) ka paraqitur një kërkesë të harruar fjalëkalimin për llogarinë tuaj në {forum}.

Nëse keni qenë ju, klikoni lidhjen e mëposhtme për të rivendosur fjalëkalimin tuaj:
{url}

Nëse nuk dëshironi të ndryshoni fjalëkalimin tuaj, thjesht injoroni këtë email dhe asgjë nuk do të ndodhë.',
    'core.email.reset_password.subject' => 'Reseto fjalëkalimin ',
    'core.forum.change_email.confirm_password_placeholder' => 'Konfirmo fjalëkalimin',
    'core.forum.change_email.confirmation_message' => 'Kemi dërguar një email konfirmimi te {email}. Nëse nuk ju vjen, ju lutemi të shikoni folderin Spam.',
    'core.forum.change_email.incorrect_password_message' => 'Fjalëkalimi që vendosët është i pasaktë.',
    'core.forum.change_password.send_button' => 'Dërgo email për resetimin e fjalëkalimit',
    'core.forum.change_password.text' => 'Klikoni butonin më poshtë dhe kontrolloni emailin tuaj për një link për të ndryshuar fjalëkalimin.',
    'core.forum.change_password.title' => 'Ndrysho fjalekalimin',
    'core.forum.composer_discussion.body_placeholder' => 'Shkruaj një post',
    'core.forum.composer_discussion.discard_confirmation' => 'Ju nuk e keni postuar diskutimin tuaj. Dëshironi ta fshini?',
    'core.forum.composer_discussion.submit_button' => 'Posto Diskutimin',
    'core.forum.composer_discussion.title' => 'Nis një diskutim',
    'core.forum.composer_discussion.title_placeholder' => 'Titulli i diskutimit',
    'core.forum.composer_edit.post_link' => 'Postimi #{number} në {diskutim}',
    'core.forum.composer_edit.submit_button' => 'Ruaj ndryshimet',
    'core.forum.composer_edit.view_button' => 'Shiko',
    'core.forum.composer_reply.body_placeholder' => 'Shkruaj një përgjigje...',
    'core.forum.composer_reply.discard_confirmation' => 'Ju nuk e keni postuar përgjigjen tuaj. Dëshironi ta fshini?',
    'core.forum.composer_reply.posted_message' => 'Përgjigjia juaj u postua.',
    'core.forum.composer_reply.submit_button' => 'Posto Përgjigje',
    'core.forum.composer_reply.view_button' => 'Shiko',
    'core.forum.composer.preview_tooltip' => 'Shih paraprakisht',
    'core.forum.discussion_controls.cannot_reply_button' => 'Nuk mund të përgjigjem',
    'core.forum.discussion_controls.cannot_reply_text' => 'Ju nuk keni të drejta për t\'iu përgjigjur këtij diskutimi.',
    'core.forum.discussion_controls.delete_button' => 'Fshij',
    'core.forum.discussion_controls.delete_confirmation' => 'Jeni i sigurt që dëshironi ta fshini këtë diskutim?',
    'core.forum.discussion_controls.delete_forever_button' => 'Fshije përgjithmonë',
    'core.forum.discussion_controls.log_in_to_reply_button' => 'Identifikohu për t\'u përgjigjur',
    'core.forum.discussion_controls.rename_button' => 'Riemërto',
    'core.forum.discussion_controls.reply_button' => 'Përgjigju',
    'core.forum.discussion_controls.restore_button' => 'Rikthe',
    'core.forum.discussion_controls.toggle_dropdown_accessible_label' => 'Ndrysho menynë rënëse të veprimeve të diskutimit',
    'core.forum.discussion_list.empty_text' => 'Nuk ka asnjë diskutim për momentin.',
    'core.forum.discussion_list.load_more_button' => 'Më tepër',
    'core.forum.discussion_list.replied_text' => '{username} u përgjigj {ago}',
    'core.forum.discussion_list.started_text' => '{username} filloi {ago}',
    'core.forum.forgot_password.email_sent_message' => 'Nëse emaili që vendosët është i regjistruar në këtë faqe, ne do t\'ju dërgojmë një email që përmban një lidhje për të rivendosur fjalëkalimin tuaj. Kontrolloni dosjen tuaj të postës së padëshiruar nëse nuk e merrni atë brenda ose dy minutave të ardhshme.',
    'core.forum.forgot_password.not_found_message' => 'Nuk ka asnjë përdorues të regjistruar me atë adresë emaili.',
    'core.forum.forgot_password.submit_button' => 'Rikuperoni fjalëkalimin',
    'core.forum.forgot_password.text' => 'Futni adresën tuaj të emailit dhe ne do t\'ju dërgojmë një link për të rivendosur fjalëkalimin tuaj.',
    'core.forum.forgot_password.title' => 'Keni harruar fjalëkalimin',
    'core.forum.header.admin_button' => 'Administrimi',
    'core.forum.header.back_to_index_tooltip' => 'Kthehu te Lista e Diskutimeve',
    'core.forum.header.log_in_link' => 'Identifikohu',
    'core.forum.header.log_out_button' => 'Dil',
    'core.forum.header.profile_button' => 'Profili',
    'core.forum.header.search_placeholder' => 'Kërko forumin',
    'core.forum.header.search_role_label' => 'Kërko forumin',
    'core.forum.header.settings_button' => 'Cilësimet',
    'core.forum.header.sign_up_link' => 'Regjistrohu',
    'core.forum.index_sort.latest_button' => 'Të fundit',
    'core.forum.index_sort.newest_button' => 'Më të rejat',
    'core.forum.index_sort.oldest_button' => 'Më të vjetrat',
    'core.forum.index_sort.toggle_dropdown_accessible_label' => 'Ndrysho renditjen e listës së diskutimeve',
    'core.forum.index_sort.top_button' => 'Në krye',
    'core.forum.index.all_discussions_link' => 'Të gjitha diskutimet',
    'core.forum.index.cannot_start_discussion_button' => 'Nuk mund të fillojë diskutimi',
    'core.forum.index.mark_all_as_read_confirmation' => 'Jeni të sigurt që doni ti shenjoni të gjitha diskutimet si të lexuara?',
    'core.forum.index.mark_all_as_read_tooltip' => 'Shënoji si të lexuara',
    'core.forum.index.meta_title_text' => 'Të gjitha diskutimet',
    'core.forum.index.start_discussion_button' => 'Nis një diskutim',
    'core.forum.log_in.forgot_password_link' => 'Keni harruar fjalëkalimin',
    'core.forum.log_in.password_placeholder' => 'Fjalëkalimi',
    'core.forum.log_in.remember_me_label' => 'Më mbaj mend',
    'core.forum.log_in.sign_up_text' => 'Nuk keni një llogari? <a>Regjistrohu</a>',
    'core.forum.log_in.submit_button' => 'Identifikohu',
    'core.forum.log_in.title' => 'Identifikohu',
    'core.forum.log_in.username_or_email_placeholder' => 'Emri i përdoruesit ose email',
    'core.forum.notifications.delete_all_confirm' => 'Jeni të sigurt që doni të fshini të gjitha njoftimet? Ky veprim nuk kthehet prapa.',
    'core.forum.notifications.delete_all_tooltip' => 'Fshiji të gjitha njoftimet',
    'core.forum.notifications.discussion_renamed_text' => '{username} ndryshoi titullin',
    'core.forum.notifications.empty_text' => 'Nuk ka njoftime',
    'core.forum.notifications.mark_all_as_read_tooltip' => 'Shënoji të gjitha si të lexuara',
    'core.forum.notifications.mark_as_read_tooltip' => 'Shënoji si të lexuara',
    'core.forum.notifications.title' => 'Njoftimet',
    'core.forum.notifications.toggle_dropdown_accessible_label' => 'Shiko njoftimet',
    'core.forum.notifications.tooltip' => 'Njoftimet',
    'core.forum.post_controls.delete_button' => 'Fshij',
    'core.forum.post_controls.delete_confirmation' => 'Je i sigurt që dëshiron ta fshish këtë postim përgjithmonë? Ky veprim nuk mund të zhbëhet.',
    'core.forum.post_controls.delete_forever_button' => 'Fshije përgjithmonë',
    'core.forum.post_controls.edit_button' => 'Modifiko',
    'core.forum.post_controls.hide_confirmation' => 'Jeni i sigurt që dëshironi ta fshini këtë postim?',
    'core.forum.post_controls.restore_button' => 'Rivendos',
    'core.forum.post_scrubber.now_link' => 'Tani',
    'core.forum.post_scrubber.original_post_link' => 'Postimi origjinal',
    'core.forum.post_scrubber.unread_text' => '{count} të palexuara',
    'core.forum.post_stream.discussion_renamed_old_tooltip' => 'Titulli i vjetër ishte: "{old}"',
    'core.forum.post_stream.discussion_renamed_text' => '{username} ndryshoi titullin në {new} {time}.',
    'core.forum.post_stream.load_more_button' => 'Më tepër',
    'core.forum.post_stream.reply_placeholder' => 'Shkruaj një përgjigje...',
    'core.forum.post_stream.time_lapsed_text' => 'Më vonë',
    'core.forum.post.edited_text' => 'U ndryshua',
    'core.forum.post.edited_tooltip' => '{username} redaktuar {ago}',
    'core.forum.post.number_tooltip' => 'Postimi #{number}',
    'core.forum.rename_discussion.submit_button' => 'Riemërto',
    'core.forum.rename_discussion.title' => 'Riemërto diskutimet',
    'core.forum.search.all_discussions_button' => 'Kërko të gjitha diskutimet për "{query}"',
    'core.forum.search.discussions_heading' => 'Diskutime',
    'core.forum.security.empty_text' => 'Nuk ka asgjë për të parë për momentin.',
    'core.forum.security.global_logout.help_text' => 'Pastron sesionin aktual të cookie-ve, përfundon të gjitha seancat, revokon argumentet e zhvilluesit dhe zhvlerëson çdo email konfirmimi të emailit ose rivendosjen e fjalëkalimit.',
    'core.forum.security.global_logout.log_out_button' => 'Dil',
    'core.forum.security.never' => 'Kurrë',
    'core.forum.security.new_access_token_modal.title_placeholder' => 'Titulli',
    'core.forum.security.title' => 'Siguria',
    'core.forum.settings.account_heading' => 'Llogaria',
    'core.forum.settings.change_email_button' => 'Ndrysho e-mail',
    'core.forum.settings.change_password_button' => 'Ndrysho fjalëkalimin',
    'core.forum.settings.notifications_heading' => 'Njoftimet',
    'core.forum.settings.notify_by_email_heading' => 'E-mail',
    'core.forum.settings.notify_discussion_renamed_label' => 'Dikush riemërton një diskutim që kam nisur',
    'core.forum.settings.privacy_disclose_online_label' => 'Lejo të tjerët të shohin kur jam në linjë',
    'core.forum.settings.privacy_heading' => 'Privatësia',
    'core.forum.settings.title' => 'Cilësimet',
    'core.forum.sign_up.log_in_text' => 'Ke një llogari? <a>Identifikohu</a>',
    'core.forum.sign_up.password_placeholder' => 'Fjalëkalimi',
    'core.forum.sign_up.submit_button' => 'Regjistrohu',
    'core.forum.sign_up.title' => 'Regjistrohu',
    'core.forum.sign_up.username_placeholder' => 'Emri i përdoruesit (p.sh: emermbiemer)',
    'core.forum.sign_up.welcome_text' => 'Mirëseerdhe, {username}!',
    'core.forum.user_controls.button' => 'Kontrollet',
    'core.forum.user_controls.delete_button' => 'Fshij',
    'core.forum.user_controls.delete_confirmation' => 'Jeni i sigurt që dëshironi ta fshini këtë përdorues? Postimet e përdoruesit NUK do të fshihen.',
    'core.forum.user_controls.delete_error_message' => 'Fshirja e përdoruesit <i>{username} ({email})</i> dështoi',
    'core.forum.user_controls.delete_success_message' => 'Përdoruesi <i>{username} ({email})</i> u fshi',
    'core.forum.user_controls.edit_button' => 'Modifiko',
    'core.forum.user_email_confirmation.alert_message' => 'Kemi dërguar një email konfirmimi te {email}. Nëse nuk ju vjen, ju lutemi të shikoni folderin Spam.',
    'core.forum.user_email_confirmation.resend_button' => 'Ridërgo Emailin e Konfirmimit',
    'core.forum.user_email_confirmation.sent_message' => 'Dërguar',
    'core.forum.user.discussions_link' => 'Diskutime',
    'core.forum.user.in_discussion_text' => 'Në {discussion}',
    'core.forum.user.joined_date_text' => 'Regjistruar {ago}',
    'core.forum.user.online_text' => 'Në linjë',
    'core.forum.user.posts_empty_text' => 'Nuk ka asnjë postim për momentin.',
    'core.forum.user.posts_link' => 'Postimet',
    'core.forum.user.posts_load_more_button' => 'Më tepër',
    'core.forum.user.security_link' => 'Siguria',
    'core.forum.user.settings_link' => 'Cilësimet',
    'core.lib.edit_user.activate_button' => 'Aktivizo përdorues',
    'core.lib.edit_user.email_heading' => 'E-mail',
    'core.lib.edit_user.email_label' => 'E-mail',
    'core.lib.edit_user.groups_heading' => 'Grupe',
    'core.lib.edit_user.password_heading' => 'Fjalëkalimi',
    'core.lib.edit_user.password_label' => 'Fjalëkalimi',
    'core.lib.edit_user.set_password_label' => 'Vendos një fjalëkalim të ri',
    'core.lib.edit_user.submit_button' => 'Ruaj ndryshimet',
    'core.lib.edit_user.title' => 'Modifiko përdorues',
    'core.lib.edit_user.username_heading' => 'Emri i përdoruesit',
    'core.lib.edit_user.username_label' => 'Emri i përdoruesit',
    'core.lib.error.rate_limit_exceeded_message' => 'Jeni duke e provouar shumë shpejt këtë veprim. Ju lutem provoni pas disa sekondash.',
    'core.ref.all_discussions' => 'Të gjitha diskutimet',
    'core.ref.change_password' => 'Ndrysho fjalëkalimin',
    'core.ref.confirm_password' => 'Konfirmo fjalëkalimin',
    'core.ref.confirmation_email_sent' => 'Kemi dërguar një email konfirmimi te {email}. Nëse nuk ju vjen, ju lutemi të shikoni folderin Spam.',
    'core.ref.discussions' => 'Diskutime',
    'core.ref.edit' => 'Modifiko',
    'core.ref.edit_user' => 'Modifiko përdorues',
    'core.ref.log_in' => 'Identifikohu',
    'core.ref.log_out' => 'Dil',
    'core.ref.mark_all_as_read' => 'Shënoji si të lexuara',
    'core.ref.notifications' => 'Njoftimet',
    'core.ref.password' => 'Fjalëkalimi',
    'core.ref.posts' => 'Postimet',
    'core.ref.rename' => 'Riemërto',
    'core.ref.reply' => 'Përgjigju',
    'core.ref.reset_your_password' => 'Reseto fjalëkalimin',
    'core.ref.security' => 'Siguria',
    'core.ref.settings' => 'Cilësimet',
    'core.ref.sign_up' => 'Regjistrohu',
    'core.ref.start_a_discussion' => 'Nis një diskutim',
    'core.ref.username' => 'Emri i përdoruesit',
    'core.ref.write_a_reply' => 'Shkruaj një përgjigje...',
    'core.views.admin.title' => 'Administrimi',
    'core.views.discussion.next_page_button' => 'Faqja tjetër',
    'core.views.index.all_discussions_heading' => 'Të gjitha diskutimet',
    'core.views.log_out.log_out_button' => 'Dil',
    'core.views.log_out.title' => 'Dil',
    'core.views.reset_password.confirm_password_label' => 'Konfirmo fjalëkalimin e ri',
    'core.views.reset_password.new_password_label' => 'Fjalëkalim i ri',
    'core.views.reset_password.submit_button' => 'Ruaj ndryshimet',
    'core.views.reset_password.title' => 'Reseto fjalëkalimin',
    'flarum-approval.admin.permissions.approve_posts_label' => 'Mirato postimet',
    'flarum-approval.admin.permissions.reply_without_approval_label' => 'Përgjigjuni diskutimeve pa miratim',
    'flarum-approval.admin.permissions.start_discussions_without_approval_label' => 'Filloni diskutimet pa miratim',
    'flarum-approval.forum.post_controls.approve_button' => 'Mirato',
    'flarum-approval.forum.post.awaiting_approval_text' => 'Në pritje të miratimit',
    'flarum-flags.admin.permissions.flag_posts_label' => 'Shenjoni postimet',
    'flarum-flags.admin.permissions.view_flags_label' => 'Shiko postimet e shenjuara',
    'flarum-flags.admin.settings.flag_own_posts_label' => 'Lejoni përdoruesit të raportojnë postimet e tyre',
    'flarum-flags.admin.settings.guidelines_url_label' => 'URL-ja e udhëzimeve të përbashkëta',
    'flarum-flags.admin.settings.title' => 'Cilësimet e shenjimeve',
    'flarum-flags.forum.flag_post.confirmation_message' => 'Faleminderit që e shenjuat këtë postim. Moderatorët tanë do ta shqyrtojnë atë.',
    'flarum-flags.forum.flag_post.reason_details_placeholder' => 'Detaje shtesë (opsionale)',
    'flarum-flags.forum.flag_post.reason_inappropriate_label' => 'E papërshtatshme',
    'flarum-flags.forum.flag_post.reason_inappropriate_text' => 'Ky postim është fyes, abuziv ose shkel <a>udhëzimet tona të komunitetit</a>.',
    'flarum-flags.forum.flag_post.reason_missing_message' => 'Ju lutemi jepni disa detaje për moderatorët tanë.',
    'flarum-flags.forum.flag_post.reason_off_topic_label' => 'Jashtë temës',
    'flarum-flags.forum.flag_post.reason_off_topic_text' => 'Ky postim nuk është i rëndësishëm për diskutimin aktual dhe duhet të zhvendoset diku tjetër.',
    'flarum-flags.forum.flag_post.reason_other_label' => 'Të tjera (ju lutem specifikojini)',
    'flarum-flags.forum.flag_post.reason_spam_text' => 'Ky postim është një reklamë.',
    'flarum-flags.forum.flag_post.submit_button' => 'Shenjo postimin',
    'flarum-flags.forum.flag_post.title' => 'Shenjo postimin',
    'flarum-flags.forum.flagged_posts.empty_text' => 'Nuk ka shenjime',
    'flarum-flags.forum.flagged_posts.item_text' => '{username} në <em>{discussion}</em>',
    'flarum-flags.forum.flagged_posts.title' => 'Postimet e shenjuara',
    'flarum-flags.forum.flagged_posts.tooltip' => 'Postimet e shenjuara',
    'flarum-flags.forum.post_controls.flag_button' => 'Shenjo',
    'flarum-flags.forum.post.dismiss_flag_button' => 'Hiq shenjimin',
    'flarum-flags.forum.post.flagged_by_text' => 'Shenjuar nga {username}',
    'flarum-flags.forum.post.flagged_by_with_reason_text' => 'Shenjuar me {emër përdoruesi} si {reason}',
    'flarum-flags.ref.flag_post' => 'Shenjo postimin',
    'flarum-flags.ref.flagged_posts' => 'Postimet e shenjuara',
    'flarum-likes.admin.permissions.like_posts_label' => 'Postimet e pëlqyera',
    'flarum-likes.admin.settings.like_own_posts_help' => 'Kur aktivizohet, me leje, përdoruesit mund të \'pëlqejnë\' postimet e tyre në forum. Për të parandaluar që përdoruesit të vendosin një "pëlqim" në postimet e tyre, çaktivizoni këtë cilësim.',
    'flarum-likes.admin.settings.like_own_posts_label' => 'Përdoruesit mund të pëlqejnë postimet e tyre',
    'flarum-likes.forum.notifications.post_liked_text' => '{username} e pëlqeu postimin tuaj',
    'flarum-likes.forum.post_likes.load_more_button' => 'Më tepër',
    'flarum-likes.forum.post_likes.title' => 'Përdoruesit që pëlqejnë këtë',
    'flarum-likes.forum.post.like_link' => 'Pëlqej',
    'flarum-likes.forum.post.liked_by_self_text' => '{users} e pëlqen këtë post.',
    'flarum-likes.forum.post.liked_by_text' => '{count, plural, one {{users} e pëlqen këtë} të tjerë {{users} like this}}.',
    'flarum-likes.forum.post.unlike_link' => 'Nuk e pëlqej',
    'flarum-likes.forum.post.you_text' => 'Ti',
    'flarum-likes.forum.settings.notify_post_liked_label' => 'Dikush pëlqen një nga postimet e mia',
    'flarum-likes.forum.user.likes_link' => 'Pëlqimet',
    'flarum-lock.forum.discussion_controls.lock_button' => 'Kyç',
    'flarum-lock.forum.notifications.discussion_locked_text' => '{username} i kyçur',
    'flarum-lock.forum.post_stream.discussion_locked_text' => '{username} e mbylli diskutimin {time}.',
    'flarum-lock.forum.post_stream.discussion_unlocked_text' => '{username} e shkyçi diskutimin {time}.',
    'flarum-lock.forum.settings.notify_discussion_locked_label' => 'Dikush kyç një diskutim që unë kam nisur',
    'flarum-mentions.admin.settings.allow_username_format_label' => 'Lejo formatin e përmendjes së emrit të përdoruesit (@Username)',
    'flarum-mentions.email.group_mentioned.body' => 'Përshëndetje {recipient_display_name}!

{mentioner_display_name} ka përmëndur grupin ku jeni anëtar në {title}.

{url}

---

{content}',
    'flarum-mentions.email.group_mentioned.subject' => '{mentioner_display_name} ka përmëndur grupin ku jeni anëtar në {title}.',
    'flarum-mentions.email.post_mentioned.body' => 'Hey {recipient_display_name}!

{replier_display_name} iu përgjigj postimit tuaj (#{post_number}) në {title}.

{url}

---

{content}',
    'flarum-mentions.email.post_mentioned.subject' => '{replier_display_name} iu përgjigj postimit tuaj në {title}',
    'flarum-mentions.email.user_mentioned.body' => 'Hej {recipient_display_name}!

{mentioner_display_name} ju përmendi në një postim në {title}.

{url}

---

{content}',
    'flarum-mentions.email.user_mentioned.subject' => '{mentioner_display_name} ju përmëndi në {title}',
    'flarum-mentions.forum.composer.mention_tooltip' => 'Përmendni një përdorues, grup ose postim',
    'flarum-mentions.forum.composer.reply_to_post_text' => 'Përgjigju #{number}',
    'flarum-mentions.forum.mentioned_by.title' => 'Përgjigjet për këtë postim',
    'flarum-mentions.forum.notifications.group_mentioned_text' => '{username} përmendi një grup në të cilin jeni anëtar',
    'flarum-mentions.forum.notifications.post_mentioned_text' => '{username} u përgjigj te postimi yt',
    'flarum-mentions.forum.notifications.user_mentioned_text' => '{username} ju përmendi',
    'flarum-mentions.forum.post.mentioned_by_more_text' => '{count} më shumë përgjigje.',
    'flarum-mentions.forum.post.mentioned_by_self_text' => '{users} iu përgjigj kësaj.',
    'flarum-mentions.forum.post.mentioned_by_text' => '{users} iu përgjigj kësaj.',
    'flarum-mentions.forum.post.quote_button' => 'Citim',
    'flarum-mentions.forum.post.reply_link' => 'Përgjigju',
    'flarum-mentions.forum.post.you_text' => 'Ti',
    'flarum-mentions.forum.settings.notify_group_mentioned_label' => 'Dikush përmënd grupin ku bëj pjesë në një postim',
    'flarum-mentions.forum.settings.notify_post_mentioned_label' => 'Dikush përgjigjet në një nga postimet e mia',
    'flarum-mentions.forum.settings.notify_user_mentioned_label' => 'Dikush më përmënd në një postim',
    'flarum-mentions.forum.user.mentions_link' => 'Citimet',
    'flarum-statistics.admin.statistics.last_28_days_label' => '28 ditët e fundit',
    'flarum-statistics.admin.statistics.last_7_days_label' => '7 ditët e fundit',
    'flarum-statistics.admin.statistics.posts_heading' => 'Postimet',
    'flarum-statistics.admin.statistics.previous_28_days_label' => '28 ditët e mëparshme',
    'flarum-statistics.admin.statistics.previous_7_days_label' => '7 ditët e mëparshme',
    'flarum-sticky.admin.permissions.sticky_discussions_label' => 'Diskutimet e shenjuara',
    'flarum-sticky.forum.badge.sticky_tooltip' => 'Shenjo',
    'flarum-sticky.forum.discussion_controls.unsticky_button' => 'Hiq shenjuesin',
    'flarum-sticky.forum.post_stream.discussion_stickied_text' => '{username} e shenjoi diskutimin {time}.',
    'flarum-sticky.forum.post_stream.discussion_unstickied_text' => '{username} e çshenjoi diskutimin {time}.',
    'flarum-sticky.ref.sticky' => 'Shenjo',
    'flarum-subscriptions.email.new_post.body' => 'Hej {recipient_display_name}!

{poster_display_name} bëri një postim në një diskutim që po ndiqni: {title}.

Për të parë aktivitetin e ri, shikoni lidhjen e mëposhtme:
{url}

---

{content}

---

Nuk do të marrësh më njoftime për këtë diskutim derisa të jesh i përditësuar.',
    'flarum-subscriptions.email.new_post.subject' => '[Postim i ri] {title}',
    'flarum-subscriptions.forum.badge.following_tooltip' => 'Ndjek',
    'flarum-subscriptions.forum.discussion_controls.follow_button' => 'Ndiq',
    'flarum-subscriptions.forum.discussion_controls.unfollow_button' => 'Ndalo së ndjekuri',
    'flarum-subscriptions.forum.following.meta_title_text' => 'Ndjek',
    'flarum-subscriptions.forum.index.following_link' => 'Ndjek',
    'flarum-subscriptions.forum.notifications.new_post_text' => '{username} postoi',
    'flarum-subscriptions.forum.settings.follow_after_reply_label' => 'Ndiq automatikisht diskutimet që unë jam përgjigjur',
    'flarum-subscriptions.forum.settings.notify_for_all_posts_label' => 'Më njofto për çdo postim të ri e jo vetëm për postimin e fundit në një diskutim',
    'flarum-subscriptions.forum.settings.notify_new_post_label' => 'Dikush poston në një diskutim që po ndjek',
    'flarum-subscriptions.forum.sub_controls.following_button' => 'Ndjek',
    'flarum-subscriptions.forum.sub_controls.following_text' => 'Njoftohuni për të gjitha përgjigjet.',
    'flarum-subscriptions.forum.sub_controls.ignoring_text' => 'Asnjëherë mos u njoftoni. Fshihuni nga lista e diskutimit.',
    'flarum-subscriptions.forum.sub_controls.not_following_button' => 'Nuk e ndjek',
    'flarum-subscriptions.forum.sub_controls.not_following_text' => 'Njoftohuni vetëm kur @përmendeni.',
    'flarum-subscriptions.forum.sub_controls.notify_alert_tooltip' => 'Merrni një njoftim forumi kur ka postime të reja',
    'flarum-subscriptions.forum.sub_controls.notify_email_tooltip' => 'Merrni një email kur ka postime të reja',
    'flarum-subscriptions.ref.follow' => 'Ndiq',
    'flarum-subscriptions.ref.following' => 'Ndjek',
    'flarum-suspend.forum.suspend_user.limited_time_days_text' => 'ditë',
    'flarum-suspend.forum.suspend_user.title' => 'Pezulloni {username}',
    'flarum-tags.admin.basics.tags_label' => 'Etiketa',
    'flarum-tags.admin.edit_tag.color_label' => 'Ngjyra',
    'flarum-tags.admin.edit_tag.delete_tag_button' => 'Fshij etiketën',
    'flarum-tags.admin.edit_tag.delete_tag_confirmation' => 'Jeni i sigurt që dëshironi ta fshini këtë etiketë? Diskutimet e etiketës NUK do të fshihen.',
    'flarum-tags.admin.edit_tag.description_label' => 'Përshkrimi',
    'flarum-tags.admin.edit_tag.hide_label' => 'Fshihu nga të gjitha diskutimet',
    'flarum-tags.admin.edit_tag.icon_label' => 'Ikona',
    'flarum-tags.admin.edit_tag.name_label' => 'Emri',
    'flarum-tags.admin.edit_tag.name_placeholder' => 'Emri',
    'flarum-tags.admin.edit_tag.submit_button' => 'Ruaj ndryshimet',
    'flarum-tags.admin.edit_tag.title' => 'Krijo etiketë',
    'flarum-tags.admin.nav.tags_button' => 'Etiketa',
    'flarum-tags.admin.settings.button_text' => 'Zgjidh etiketat',
    'flarum-tags.admin.tags.settings_heading' => 'Cilësimet',
    'flarum-tags.forum.all_tags.meta_title_text' => 'Etiketa',
    'flarum-tags.forum.choose_tags.title' => 'Zgjidhni etiketat për diskutimin tuaj',
    'flarum-tags.forum.composer_discussion.choose_tags_link' => 'Zgjidh etiketat',
    'flarum-tags.forum.discussion_controls.edit_tags_button' => 'Modifiko etiketat',
    'flarum-tags.forum.index.tags_link' => 'Etiketa',
    'flarum-tags.forum.post_stream.added_and_removed_tags_text' => '{username} shtoi {tagsAdded} dhe hoqi {tagsRemoved} {time}.',
    'flarum-tags.forum.post_stream.added_tags_text' => '{username} shtoi {tagsAdded} {time}.',
    'flarum-tags.forum.post_stream.removed_tags_text' => '{username} hoqi {tagsRemoved} {time}.',
    'flarum-tags.forum.post_stream.tags_text' => '{count, plural, one {{tags} tag} të tjerë {{tags} tags}}',
    'flarum-tags.forum.tag.meta_description_text' => 'Të gjitha diskutimet me tag-un "tag"',
    'flarum-tags.lib.tag_selection_modal.title' => 'Zgjidh etiketat',
    'flarum-tags.ref.choose_tags' => 'Zgjidh etiketat',
    'validation.attributes.password' => 'fjalëkalim',
    'validation.attributes.username' => 'emri i përdoruesit',
    'validation.password' => 'Fjalëkalimi është i pasaktë.',
  ),
));


return $catalogue;
